/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.model.system.TcpClientConfiguration;
import com.axibase.tsd.util.AtsdUtil;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class TcpClientConfigurationFactory {
    private static final int DEFAULT_TCP_PORT = 8081;
    private static final boolean DEFAULT_AUTOFLUSH = false;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 3000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 10000;
    private static final String DEFAULT_CLIENT_PROPERTIES_FILE_NAME = "classpath:/client.properties";
    private static final String AXIBASE_TSD_API_DOMAIN = "axibase.tsd.api";
    private String serverName;
    private int port;
    private boolean autoflush;
    private int connectionTimeoutMs;
    private int readTimeoutMs;

    private TcpClientConfigurationFactory() {
    }

    public static TcpClientConfigurationFactory createInstance() {
        String clientPropertiesFileName = DEFAULT_CLIENT_PROPERTIES_FILE_NAME;
        String sysPropertiesFileName = System.getProperty("axibase.tsd.api.client.properties");
        if (StringUtils.isNotBlank((CharSequence)sysPropertiesFileName)) {
            clientPropertiesFileName = sysPropertiesFileName;
        }
        return TcpClientConfigurationFactory.createInstance(clientPropertiesFileName);
    }

    public static TcpClientConfigurationFactory createInstance(String clientPropertiesFileName) {
        Properties clientProperties = AtsdUtil.loadProperties(clientPropertiesFileName);
        TcpClientConfigurationFactory configurationFactory = new TcpClientConfigurationFactory();
        configurationFactory.serverName = AtsdUtil.getPropertyStringValue("axibase.tsd.api.server.name", clientProperties, null);
        configurationFactory.port = AtsdUtil.getPropertyIntValue("axibase.tsd.api.server.tcp.port", clientProperties, 8081);
        configurationFactory.autoflush = AtsdUtil.getPropertyBoolValue("axibase.tsd.api.server.tcp.autoflush", clientProperties, false);
        configurationFactory.connectionTimeoutMs = AtsdUtil.getPropertyIntValue("axibase.tsd.api.server.tcp.connectionTimeoutMs", clientProperties, 3000);
        configurationFactory.readTimeoutMs = AtsdUtil.getPropertyIntValue("axibase.tsd.api.server.tcp.readTimeoutMs", clientProperties, 10000);
        return configurationFactory;
    }

    public TcpClientConfigurationFactory(String serverName, int port, boolean autoflush, int connectionTimeoutMs, int readTimeoutMs) {
        this.serverName = serverName;
        this.port = port;
        this.autoflush = autoflush;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
    }

    public TcpClientConfiguration createClientConfiguration() {
        return new TcpClientConfiguration(this.serverName, this.port, this.autoflush, this.connectionTimeoutMs, this.readTimeoutMs);
    }
}

