/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.client.AtsdClientException;
import com.axibase.tsd.client.TcpClient;
import com.axibase.tsd.model.system.TcpClientConfiguration;
import com.axibase.tsd.network.PlainCommand;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class TcpClientManager {
    private static final int DEFAULT_BORROW_MAX_TIME_MS = 3000;
    private static final int DEFAULT_MAX_TOTAL = 8;
    private static final int DEFAULT_MAX_IDLE = 8;
    private GenericObjectPoolConfig objectPoolConfig;
    private AtomicReference<GenericObjectPool<TcpClient>> objectPoolAtomicReference = new AtomicReference();
    private int borrowMaxWaitMillis = 3000;
    private TcpClientConfiguration clientConfiguration;

    public TcpClientManager() {
        this.objectPoolConfig = new GenericObjectPoolConfig();
        this.objectPoolConfig.setMaxTotal(8);
        this.objectPoolConfig.setMaxIdle(8);
    }

    public TcpClientManager(TcpClientConfiguration clientConfiguration) {
        this();
        this.clientConfiguration = clientConfiguration;
    }

    public void setClientConfiguration(TcpClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public void setObjectPoolConfig(GenericObjectPoolConfig objectPoolConfig) {
        this.objectPoolConfig = objectPoolConfig;
    }

    public void setBorrowMaxWaitMillis(int borrowMaxWaitMillis) {
        this.borrowMaxWaitMillis = borrowMaxWaitMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(PlainCommand plainCommand) {
        TcpClient tcpClient = this.borrowClient();
        try {
            tcpClient.send(plainCommand);
        }
        finally {
            this.returnClient(tcpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Collection<PlainCommand> plainCommand) {
        TcpClient tcpClient = this.borrowClient();
        try {
            tcpClient.send(plainCommand);
        }
        finally {
            this.returnClient(tcpClient);
        }
    }

    private TcpClient borrowClient() {
        TcpClient tcpClient;
        GenericObjectPool<TcpClient> objectPool = this.createObjectPool();
        try {
            tcpClient = (TcpClient)objectPool.borrowObject((long)this.borrowMaxWaitMillis);
        }
        catch (Exception e) {
            throw new AtsdClientException("Could not borrow tcp client from pool", e);
        }
        return tcpClient;
    }

    private void returnClient(TcpClient tcpClient) {
        this.objectPoolAtomicReference.get().returnObject((Object)tcpClient);
    }

    private GenericObjectPool<TcpClient> createObjectPool() {
        GenericObjectPool tcpClientGenericObjectPool = this.objectPoolAtomicReference.get();
        if (tcpClientGenericObjectPool == null) {
            tcpClientGenericObjectPool = new GenericObjectPool((PooledObjectFactory)new TcpClientBasePooledObjectFactory(), this.objectPoolConfig);
            this.objectPoolAtomicReference.compareAndSet(null, (GenericObjectPool<TcpClient>)tcpClientGenericObjectPool);
        }
        return this.objectPoolAtomicReference.get();
    }

    public void close() {
        GenericObjectPool<TcpClient> pool = this.objectPoolAtomicReference.get();
        if (pool != null) {
            pool.close();
        }
    }

    private class TcpClientBasePooledObjectFactory
    extends BasePooledObjectFactory<TcpClient> {
        private TcpClientBasePooledObjectFactory() {
        }

        public TcpClient create() throws Exception {
            return new TcpClient(TcpClientManager.this.clientConfiguration);
        }

        public PooledObject<TcpClient> wrap(TcpClient tcpClient) {
            return new DefaultPooledObject((Object)tcpClient);
        }

        public void destroyObject(PooledObject<TcpClient> p) throws Exception {
            ((TcpClient)p.getObject()).close();
        }
    }
}

