/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.data.series;

import com.axibase.tsd.util.BigDecimalDeserializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Sample {
    @JsonProperty(value="t")
    private Long timeMillis;
    @JsonProperty(value="d")
    private String isoDate;
    @JsonDeserialize(using=BigDecimalDeserializer.class)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="v")
    private BigDecimal numericValue;
    @JsonProperty(value="x")
    private String textValue;

    @JsonCreator
    private Sample() {
    }

    private Sample(Long timeMillis, String isoDate, BigDecimal numericValue, String textValue) {
        this.timeMillis = timeMillis;
        this.isoDate = isoDate;
        this.numericValue = numericValue;
        this.textValue = textValue;
    }

    public Sample(long timeMillis, double numericValue, String textValue) {
        this(timeMillis, null, null, textValue);
        this.setNumericValueFromDouble(numericValue);
    }

    public static Sample ofTimeDouble(long time, double numericValue) {
        return new Sample(time, null, null, null).setNumericValueFromDouble(numericValue);
    }

    public static Sample ofIsoDouble(String isoDate, double numericValue) {
        return new Sample(null, isoDate, null, null).setNumericValueFromDouble(numericValue);
    }

    public static Sample ofTimeDoubleText(long time, double numericValue, String textValue) {
        return new Sample(time, null, null, textValue).setNumericValueFromDouble(numericValue);
    }

    public static Sample ofIsoDoubleText(String isoDate, double numericValue, String textValue) {
        return new Sample(null, isoDate, null, textValue).setNumericValueFromDouble(numericValue);
    }

    public static Sample ofTimeText(long time, String textValue) {
        return new Sample(time, null, null, textValue);
    }

    public static Sample ofIsoText(String isoDate, String textValue) {
        return new Sample(null, isoDate, null, textValue);
    }

    @JsonIgnore
    public double getNumericValueAsDouble() {
        return this.numericValue == null ? Double.NaN : this.numericValue.doubleValue();
    }

    @JsonIgnore
    public Sample setNumericValueFromDouble(double numericValue) {
        this.numericValue = Double.isNaN(numericValue) || Double.isInfinite(numericValue) ? null : BigDecimal.valueOf(numericValue);
        return this;
    }

    public Long getTimeMillis() {
        return this.timeMillis;
    }

    public String getIsoDate() {
        return this.isoDate;
    }

    public BigDecimal getNumericValue() {
        return this.numericValue;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public Sample setTimeMillis(Long timeMillis) {
        this.timeMillis = timeMillis;
        return this;
    }

    public Sample setIsoDate(String isoDate) {
        this.isoDate = isoDate;
        return this;
    }

    public Sample setNumericValue(BigDecimal numericValue) {
        this.numericValue = numericValue;
        return this;
    }

    public Sample setTextValue(String textValue) {
        this.textValue = textValue;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sample)) {
            return false;
        }
        Sample other = (Sample)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$timeMillis = this.getTimeMillis();
        Long other$timeMillis = other.getTimeMillis();
        if (this$timeMillis == null ? other$timeMillis != null : !((Object)this$timeMillis).equals(other$timeMillis)) {
            return false;
        }
        String this$isoDate = this.getIsoDate();
        String other$isoDate = other.getIsoDate();
        if (this$isoDate == null ? other$isoDate != null : !this$isoDate.equals(other$isoDate)) {
            return false;
        }
        BigDecimal this$numericValue = this.getNumericValue();
        BigDecimal other$numericValue = other.getNumericValue();
        if (this$numericValue == null ? other$numericValue != null : !((Object)this$numericValue).equals(other$numericValue)) {
            return false;
        }
        String this$textValue = this.getTextValue();
        String other$textValue = other.getTextValue();
        return !(this$textValue == null ? other$textValue != null : !this$textValue.equals(other$textValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sample;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timeMillis = this.getTimeMillis();
        result = result * 59 + ($timeMillis == null ? 43 : ((Object)$timeMillis).hashCode());
        String $isoDate = this.getIsoDate();
        result = result * 59 + ($isoDate == null ? 43 : $isoDate.hashCode());
        BigDecimal $numericValue = this.getNumericValue();
        result = result * 59 + ($numericValue == null ? 43 : ((Object)$numericValue).hashCode());
        String $textValue = this.getTextValue();
        result = result * 59 + ($textValue == null ? 43 : $textValue.hashCode());
        return result;
    }

    public String toString() {
        return "Sample(timeMillis=" + this.getTimeMillis() + ", isoDate=" + this.getIsoDate() + ", numericValue=" + this.getNumericValue() + ", textValue=" + this.getTextValue() + ")";
    }
}

