/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.meta;

import com.axibase.tsd.model.meta.InterpolationType;
import com.axibase.tsd.util.AtsdUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.TimeZone;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Entity {
    @NonNull
    private String name;
    private String label;
    private Boolean enabled;
    private InterpolationType interpolationType;
    private TimeZone timeZone;
    private String lastInsertDate;
    private Map<String, String> tags;

    @JsonIgnore
    public Entity buildTags(String ... tagNamesAndValues) {
        return this.setTags(AtsdUtil.toMap(tagNamesAndValues));
    }

    @ConstructorProperties(value={"name"})
    public Entity(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public InterpolationType getInterpolationType() {
        return this.interpolationType;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getLastInsertDate() {
        return this.lastInsertDate;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Entity setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        return this;
    }

    public Entity setLabel(String label) {
        this.label = label;
        return this;
    }

    public Entity setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Entity setInterpolationType(InterpolationType interpolationType) {
        this.interpolationType = interpolationType;
        return this;
    }

    public Entity setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public Entity setLastInsertDate(String lastInsertDate) {
        this.lastInsertDate = lastInsertDate;
        return this;
    }

    public Entity setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        InterpolationType this$interpolationType = this.getInterpolationType();
        InterpolationType other$interpolationType = other.getInterpolationType();
        if (this$interpolationType == null ? other$interpolationType != null : !((Object)((Object)this$interpolationType)).equals((Object)other$interpolationType)) {
            return false;
        }
        TimeZone this$timeZone = this.getTimeZone();
        TimeZone other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$lastInsertDate = this.getLastInsertDate();
        String other$lastInsertDate = other.getLastInsertDate();
        if (this$lastInsertDate == null ? other$lastInsertDate != null : !this$lastInsertDate.equals(other$lastInsertDate)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Entity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        InterpolationType $interpolationType = this.getInterpolationType();
        result = result * 59 + ($interpolationType == null ? 43 : ((Object)((Object)$interpolationType)).hashCode());
        TimeZone $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $lastInsertDate = this.getLastInsertDate();
        result = result * 59 + ($lastInsertDate == null ? 43 : $lastInsertDate.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Entity(name=" + this.getName() + ", label=" + this.getLabel() + ", enabled=" + this.getEnabled() + ", interpolationType=" + (Object)((Object)this.getInterpolationType()) + ", timeZone=" + this.getTimeZone() + ", lastInsertDate=" + this.getLastInsertDate() + ", tags=" + this.getTags() + ")";
    }
}

