/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.meta;

import com.axibase.tsd.model.meta.DataType;
import com.axibase.tsd.model.meta.InterpolationType;
import com.axibase.tsd.model.meta.InvalidAction;
import com.axibase.tsd.model.meta.TimePrecision;
import com.axibase.tsd.util.AtsdUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.TimeZone;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Metric {
    @NonNull
    private String name;
    private String label;
    private Boolean enabled;
    private DataType dataType;
    private String units;
    private TimeZone timeZone;
    private InterpolationType interpolationType;
    private TimePrecision timePrecision;
    private Boolean persistent;
    private String filter;
    private Double minValue;
    private Double maxValue;
    private InvalidAction invalidAction;
    private String description;
    private Integer retentionDays;
    private String lastInsertDate;
    private Boolean versioned;
    private Map<String, String> tags;

    public Metric buildTags(String ... tagNamesAndValues) {
        this.setTags(AtsdUtil.toMap(tagNamesAndValues));
        return this;
    }

    @ConstructorProperties(value={"name"})
    public Metric(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getUnits() {
        return this.units;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public InterpolationType getInterpolationType() {
        return this.interpolationType;
    }

    public TimePrecision getTimePrecision() {
        return this.timePrecision;
    }

    public Boolean getPersistent() {
        return this.persistent;
    }

    public String getFilter() {
        return this.filter;
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public InvalidAction getInvalidAction() {
        return this.invalidAction;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getRetentionDays() {
        return this.retentionDays;
    }

    public String getLastInsertDate() {
        return this.lastInsertDate;
    }

    public Boolean getVersioned() {
        return this.versioned;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Metric setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        return this;
    }

    public Metric setLabel(String label) {
        this.label = label;
        return this;
    }

    public Metric setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Metric setDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public Metric setUnits(String units) {
        this.units = units;
        return this;
    }

    public Metric setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public Metric setInterpolationType(InterpolationType interpolationType) {
        this.interpolationType = interpolationType;
        return this;
    }

    public Metric setTimePrecision(TimePrecision timePrecision) {
        this.timePrecision = timePrecision;
        return this;
    }

    public Metric setPersistent(Boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public Metric setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public Metric setMinValue(Double minValue) {
        this.minValue = minValue;
        return this;
    }

    public Metric setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public Metric setInvalidAction(InvalidAction invalidAction) {
        this.invalidAction = invalidAction;
        return this;
    }

    public Metric setDescription(String description) {
        this.description = description;
        return this;
    }

    public Metric setRetentionDays(Integer retentionDays) {
        this.retentionDays = retentionDays;
        return this;
    }

    public Metric setVersioned(Boolean versioned) {
        this.versioned = versioned;
        return this;
    }

    public Metric setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        String this$units = this.getUnits();
        String other$units = other.getUnits();
        if (this$units == null ? other$units != null : !this$units.equals(other$units)) {
            return false;
        }
        TimeZone this$timeZone = this.getTimeZone();
        TimeZone other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        InterpolationType this$interpolationType = this.getInterpolationType();
        InterpolationType other$interpolationType = other.getInterpolationType();
        if (this$interpolationType == null ? other$interpolationType != null : !((Object)((Object)this$interpolationType)).equals((Object)other$interpolationType)) {
            return false;
        }
        TimePrecision this$timePrecision = this.getTimePrecision();
        TimePrecision other$timePrecision = other.getTimePrecision();
        if (this$timePrecision == null ? other$timePrecision != null : !((Object)((Object)this$timePrecision)).equals((Object)other$timePrecision)) {
            return false;
        }
        Boolean this$persistent = this.getPersistent();
        Boolean other$persistent = other.getPersistent();
        if (this$persistent == null ? other$persistent != null : !((Object)this$persistent).equals(other$persistent)) {
            return false;
        }
        String this$filter = this.getFilter();
        String other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Double this$minValue = this.getMinValue();
        Double other$minValue = other.getMinValue();
        if (this$minValue == null ? other$minValue != null : !((Object)this$minValue).equals(other$minValue)) {
            return false;
        }
        Double this$maxValue = this.getMaxValue();
        Double other$maxValue = other.getMaxValue();
        if (this$maxValue == null ? other$maxValue != null : !((Object)this$maxValue).equals(other$maxValue)) {
            return false;
        }
        InvalidAction this$invalidAction = this.getInvalidAction();
        InvalidAction other$invalidAction = other.getInvalidAction();
        if (this$invalidAction == null ? other$invalidAction != null : !((Object)((Object)this$invalidAction)).equals((Object)other$invalidAction)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Integer this$retentionDays = this.getRetentionDays();
        Integer other$retentionDays = other.getRetentionDays();
        if (this$retentionDays == null ? other$retentionDays != null : !((Object)this$retentionDays).equals(other$retentionDays)) {
            return false;
        }
        String this$lastInsertDate = this.getLastInsertDate();
        String other$lastInsertDate = other.getLastInsertDate();
        if (this$lastInsertDate == null ? other$lastInsertDate != null : !this$lastInsertDate.equals(other$lastInsertDate)) {
            return false;
        }
        Boolean this$versioned = this.getVersioned();
        Boolean other$versioned = other.getVersioned();
        if (this$versioned == null ? other$versioned != null : !((Object)this$versioned).equals(other$versioned)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Metric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        String $units = this.getUnits();
        result = result * 59 + ($units == null ? 43 : $units.hashCode());
        TimeZone $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        InterpolationType $interpolationType = this.getInterpolationType();
        result = result * 59 + ($interpolationType == null ? 43 : ((Object)((Object)$interpolationType)).hashCode());
        TimePrecision $timePrecision = this.getTimePrecision();
        result = result * 59 + ($timePrecision == null ? 43 : ((Object)((Object)$timePrecision)).hashCode());
        Boolean $persistent = this.getPersistent();
        result = result * 59 + ($persistent == null ? 43 : ((Object)$persistent).hashCode());
        String $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Double $minValue = this.getMinValue();
        result = result * 59 + ($minValue == null ? 43 : ((Object)$minValue).hashCode());
        Double $maxValue = this.getMaxValue();
        result = result * 59 + ($maxValue == null ? 43 : ((Object)$maxValue).hashCode());
        InvalidAction $invalidAction = this.getInvalidAction();
        result = result * 59 + ($invalidAction == null ? 43 : ((Object)((Object)$invalidAction)).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Integer $retentionDays = this.getRetentionDays();
        result = result * 59 + ($retentionDays == null ? 43 : ((Object)$retentionDays).hashCode());
        String $lastInsertDate = this.getLastInsertDate();
        result = result * 59 + ($lastInsertDate == null ? 43 : $lastInsertDate.hashCode());
        Boolean $versioned = this.getVersioned();
        result = result * 59 + ($versioned == null ? 43 : ((Object)$versioned).hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Metric(name=" + this.getName() + ", label=" + this.getLabel() + ", enabled=" + this.getEnabled() + ", dataType=" + (Object)((Object)this.getDataType()) + ", units=" + this.getUnits() + ", timeZone=" + this.getTimeZone() + ", interpolationType=" + (Object)((Object)this.getInterpolationType()) + ", timePrecision=" + (Object)((Object)this.getTimePrecision()) + ", persistent=" + this.getPersistent() + ", filter=" + this.getFilter() + ", minValue=" + this.getMinValue() + ", maxValue=" + this.getMaxValue() + ", invalidAction=" + (Object)((Object)this.getInvalidAction()) + ", description=" + this.getDescription() + ", retentionDays=" + this.getRetentionDays() + ", lastInsertDate=" + this.getLastInsertDate() + ", versioned=" + this.getVersioned() + ", tags=" + this.getTags() + ")";
    }
}

