/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.system;

public class ClientConfiguration {
    public static final int DEFAULT_TIMEOUT_MS = 1000;
    public static final long DEFAULT_PING_TIMEOUT_MS = 600000L;
    private final String metadataUrl;
    private final String dataUrl;
    private final String username;
    private final String password;
    private int connectTimeoutMillis = 1000;
    private int readTimeoutMillis = 1000;
    private boolean ignoreSSLErrors = false;
    private long pingTimeoutMillis = 600000L;
    private boolean skipStreamingControl = false;
    private boolean enableBatchCompression = false;

    public ClientConfiguration(String metadataUrl, String dataUrl, String username, String password) {
        this.metadataUrl = metadataUrl;
        this.dataUrl = dataUrl;
        this.username = username;
        this.password = password;
    }

    public ClientConfiguration(String url, String username, String password) {
        this.metadataUrl = url;
        this.dataUrl = url;
        this.username = username;
        this.password = password;
    }

    public String getMetadataUrl() {
        return this.metadataUrl;
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public boolean isIgnoreSSLErrors() {
        return this.ignoreSSLErrors;
    }

    public long getPingTimeoutMillis() {
        return this.pingTimeoutMillis;
    }

    public boolean isSkipStreamingControl() {
        return this.skipStreamingControl;
    }

    public boolean isEnableBatchCompression() {
        return this.enableBatchCompression;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public void setIgnoreSSLErrors(boolean ignoreSSLErrors) {
        this.ignoreSSLErrors = ignoreSSLErrors;
    }

    public void setPingTimeoutMillis(long pingTimeoutMillis) {
        this.pingTimeoutMillis = pingTimeoutMillis;
    }

    public void setSkipStreamingControl(boolean skipStreamingControl) {
        this.skipStreamingControl = skipStreamingControl;
    }

    public void setEnableBatchCompression(boolean enableBatchCompression) {
        this.enableBatchCompression = enableBatchCompression;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfiguration)) {
            return false;
        }
        ClientConfiguration other = (ClientConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$metadataUrl = this.getMetadataUrl();
        String other$metadataUrl = other.getMetadataUrl();
        if (this$metadataUrl == null ? other$metadataUrl != null : !this$metadataUrl.equals(other$metadataUrl)) {
            return false;
        }
        String this$dataUrl = this.getDataUrl();
        String other$dataUrl = other.getDataUrl();
        if (this$dataUrl == null ? other$dataUrl != null : !this$dataUrl.equals(other$dataUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.getConnectTimeoutMillis() != other.getConnectTimeoutMillis()) {
            return false;
        }
        if (this.getReadTimeoutMillis() != other.getReadTimeoutMillis()) {
            return false;
        }
        if (this.isIgnoreSSLErrors() != other.isIgnoreSSLErrors()) {
            return false;
        }
        if (this.getPingTimeoutMillis() != other.getPingTimeoutMillis()) {
            return false;
        }
        if (this.isSkipStreamingControl() != other.isSkipStreamingControl()) {
            return false;
        }
        return this.isEnableBatchCompression() == other.isEnableBatchCompression();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $metadataUrl = this.getMetadataUrl();
        result = result * 59 + ($metadataUrl == null ? 43 : $metadataUrl.hashCode());
        String $dataUrl = this.getDataUrl();
        result = result * 59 + ($dataUrl == null ? 43 : $dataUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + this.getConnectTimeoutMillis();
        result = result * 59 + this.getReadTimeoutMillis();
        result = result * 59 + (this.isIgnoreSSLErrors() ? 79 : 97);
        long $pingTimeoutMillis = this.getPingTimeoutMillis();
        result = result * 59 + (int)($pingTimeoutMillis >>> 32 ^ $pingTimeoutMillis);
        result = result * 59 + (this.isSkipStreamingControl() ? 79 : 97);
        result = result * 59 + (this.isEnableBatchCompression() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ClientConfiguration(metadataUrl=" + this.getMetadataUrl() + ", dataUrl=" + this.getDataUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", connectTimeoutMillis=" + this.getConnectTimeoutMillis() + ", readTimeoutMillis=" + this.getReadTimeoutMillis() + ", ignoreSSLErrors=" + this.isIgnoreSSLErrors() + ", pingTimeoutMillis=" + this.getPingTimeoutMillis() + ", skipStreamingControl=" + this.isSkipStreamingControl() + ", enableBatchCompression=" + this.isEnableBatchCompression() + ")";
    }
}

