/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.util;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtsdUtil {
    private static final Logger log = LoggerFactory.getLogger(AtsdUtil.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    public static final String ADD_COMMAND = "add";
    public static final String DELETE_COMMAND = "delete";
    public static final String MARKER_KEYWORD = "marker ";
    public static final String PING_COMMAND = "ping\n";

    public static Map<String, String> toMap(String ... tagNamesAndValues) {
        if (ArrayUtils.isEmpty((Object[])tagNamesAndValues)) {
            return Collections.emptyMap();
        }
        if (tagNamesAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Key without value");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < tagNamesAndValues.length; ++i) {
            result.put(tagNamesAndValues[i], tagNamesAndValues[++i]);
        }
        return result;
    }

    public static Map<String, Double> toValuesMap(Object ... metricNamesAndValues) {
        if (ArrayUtils.isEmpty((Object[])metricNamesAndValues)) {
            return Collections.emptyMap();
        }
        if (metricNamesAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Key without value");
        }
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (int i = 0; i < metricNamesAndValues.length; ++i) {
            result.put((String)metricNamesAndValues[i], (Double)metricNamesAndValues[++i]);
        }
        return result;
    }

    public static void check(String value, String errorMessage) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkPropertyTypeIsEmpty(String type) {
        AtsdUtil.check(type, "Type is empty");
    }

    public static void checkEntityIsEmpty(String entityName) {
        AtsdUtil.check(entityName, "Entity name is empty");
    }

    public static void checkEntityGroupIsEmpty(String entityGroupName) {
        AtsdUtil.check(entityGroupName, "Entity group name is empty");
    }

    public static void checkMetricIsEmpty(String metricName) {
        AtsdUtil.check(metricName, "Metric name is empty");
    }

    public static String formatMetricValue(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return "NaN";
        }
        return Double.toString(value);
    }

    public static Properties loadProperties(String clientPropertiesFileName) {
        log.debug("Load client properties from file: {}", (Object)clientPropertiesFileName);
        Properties clientProperties = new Properties();
        try (InputStream stream = AtsdUtil.propertiesStream(clientPropertiesFileName);){
            clientProperties.load(stream);
        }
        catch (Exception e) {
            log.warn("Could not load client properties", (Throwable)e);
        }
        return clientProperties;
    }

    private static InputStream propertiesStream(String clientPropertiesFileName) throws FileNotFoundException {
        if (clientPropertiesFileName.startsWith(CLASSPATH_PREFIX)) {
            String resourcePath = StringUtils.substringAfter((String)clientPropertiesFileName, (String)CLASSPATH_PREFIX);
            log.info("Load properties from classpath: {}", (Object)resourcePath);
            return AtsdUtil.class.getResourceAsStream(resourcePath);
        }
        File file = new File(clientPropertiesFileName);
        log.info("Load properties from file: {}", (Object)file.getAbsolutePath());
        return new FileInputStream(file);
    }

    public static String getPropertyStringValue(String name, Properties clientProperties, String defaultValue) {
        String value = System.getProperty(name);
        if (value == null && (value = clientProperties.getProperty(name)) == null) {
            if (defaultValue == null) {
                log.error("Could not find required property: {}", (Object)name);
                throw new IllegalStateException(name + " property is null");
            }
            value = defaultValue;
        }
        return value;
    }

    public static Integer getPropertyIntValue(String name, Properties clientProperties, Integer defaultValue) {
        return NumberUtils.toInt((String)AtsdUtil.getPropertyStringValue(name, clientProperties, ""), (int)defaultValue);
    }

    public static Long getPropertyLongValue(String name, Properties clientProperties, Long defaultValue) {
        return NumberUtils.toLong((String)AtsdUtil.getPropertyStringValue(name, clientProperties, ""), (long)defaultValue);
    }

    public static Boolean getPropertyBoolValue(String name, Properties clientProperties, Boolean defaultValue) {
        String value = AtsdUtil.getPropertyStringValue(name, clientProperties, "");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return BooleanUtils.toBoolean((String)value);
    }

    public static boolean hasStatusFamily(Response response, Response.Status.Family family) {
        return response.getStatusInfo().getFamily().equals((Object)family);
    }

    private AtsdUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class DateTime {
        public static final String MIN_QUERIED_DATE_TIME = "1000-01-01T00:00:00.000Z";
        public static final String MAX_QUERIED_DATE_TIME = "9999-12-31T23:59:59.999Z";

        public static Date parseDate(String date) {
            try {
                return ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0));
            }
            catch (ParseException e) {
                throw new IllegalStateException(e);
            }
        }

        public static String isoFormat(Date date) {
            return DateTime.isoFormat(date, "GMT");
        }

        public static String isoFormat(Date date, String timeZoneName) {
            return DateTime.isoFormat(date, true, timeZoneName);
        }

        public static String isoFormat(Date date, boolean withMillis, String timeZoneName) {
            return ISO8601Utils.format((Date)date, (boolean)withMillis, (TimeZone)TimeZone.getTimeZone(timeZoneName));
        }

        private DateTime() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

