/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.util.AtsdUtil;
import java.beans.ConstructorProperties;
import java.util.Properties;

public class AtsdPropertyExtractor {
    private static final String AXIBASE_TSD_API_DOMAIN = "axibase.tsd.api.";
    private final Properties clientProperties;

    public long getAsLong(String name, long defaultValue) {
        return AtsdUtil.getPropertyLongValue(this.fullName(name), this.clientProperties, defaultValue);
    }

    public int getAsInt(String name, int defaultValue) {
        return AtsdUtil.getPropertyIntValue(this.fullName(name), this.clientProperties, defaultValue);
    }

    public boolean getAsBoolean(String name, boolean defaultValue) {
        return AtsdUtil.getPropertyBoolValue(this.fullName(name), this.clientProperties, defaultValue);
    }

    private String fullName(String name) {
        return String.format("%s%s", AXIBASE_TSD_API_DOMAIN, name);
    }

    public String getAsString(String name, String defaultValue) {
        return AtsdUtil.getPropertyStringValue(this.fullName(name), this.clientProperties, defaultValue);
    }

    @ConstructorProperties(value={"clientProperties"})
    public AtsdPropertyExtractor(Properties clientProperties) {
        this.clientProperties = clientProperties;
    }
}

