/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.client.AtsdPropertyExtractor;
import com.axibase.tsd.model.system.ClientConfiguration;
import com.axibase.tsd.util.AtsdUtil;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class ClientConfigurationFactory {
    private static final String DEFAULT_PROTOCOL = "http";
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 1000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 1000;
    private static final long DEFAULT_PING_TIMEOUT_MS = 600000L;
    private static final String DEFAULT_CLIENT_PROPERTIES_FILE_NAME = "classpath:/client.properties";
    private static final String AXIBASE_TSD_API_DOMAIN = "axibase.tsd.api";
    private static final String DEFAULT_API_PATH = "/api/v1";
    public static final String DEFAULT_USERNAME = "atsd-api-java";
    private String protocol;
    private String serverName;
    private String serverPort;
    private String metadataPath;
    private String dataPath;
    private String username;
    private String password;
    private int connectTimeoutMillis;
    private int readTimeoutMillis;
    private long pingTimeoutMillis;
    private boolean ignoreSSLErrors;
    private boolean skipStreamingControl;
    private boolean enableGzipCompression;
    private String userAgent;

    private ClientConfigurationFactory() {
    }

    public static ClientConfigurationFactory createInstance() {
        String clientPropertiesFileName = DEFAULT_CLIENT_PROPERTIES_FILE_NAME;
        String sysPropertiesFileName = System.getProperty("axibase.tsd.api.client.properties");
        if (StringUtils.isNotBlank((CharSequence)sysPropertiesFileName)) {
            clientPropertiesFileName = sysPropertiesFileName;
        }
        return ClientConfigurationFactory.createInstance(clientPropertiesFileName);
    }

    public ClientConfigurationFactory(String protocol, String serverName, int serverPort, String metadataPath, String dataPath, String username, String password, int connectTimeoutMillis, int readTimeoutMillis, long pingTimeoutMillis, boolean ignoreSSLErrors, boolean skipStreamingControl, boolean enableGzipCompression) {
        this(protocol, serverName, Integer.toString(serverPort), metadataPath, dataPath, username, password, connectTimeoutMillis, readTimeoutMillis, pingTimeoutMillis, ignoreSSLErrors, skipStreamingControl, enableGzipCompression);
    }

    public ClientConfigurationFactory(String protocol, String serverName, String serverPort, String metadataPath, String dataPath, String username, String password, int connectTimeoutMillis, int readTimeoutMillis, long pingTimeoutMillis, boolean ignoreSSLErrors, boolean skipStreamingControl, boolean enableGzipCompression) {
        this.serverName = serverName;
        this.serverPort = serverPort;
        this.username = username;
        this.password = password;
        this.metadataPath = metadataPath;
        this.dataPath = dataPath;
        this.protocol = protocol;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.pingTimeoutMillis = pingTimeoutMillis;
        this.ignoreSSLErrors = ignoreSSLErrors;
        this.skipStreamingControl = skipStreamingControl;
        this.enableGzipCompression = enableGzipCompression;
    }

    public static ClientConfigurationFactory createInstance(String clientPropertiesFileName) {
        Properties clientProperties = AtsdUtil.loadProperties(clientPropertiesFileName);
        ClientConfigurationFactory configurationFactory = new ClientConfigurationFactory();
        AtsdPropertyExtractor extractor = new AtsdPropertyExtractor(clientProperties);
        configurationFactory.serverName = extractor.getAsString("server.name", null);
        configurationFactory.serverPort = extractor.getAsString("server.port", null);
        configurationFactory.username = extractor.getAsString("username", null);
        configurationFactory.password = extractor.getAsString("password", null);
        configurationFactory.metadataPath = extractor.getAsString("metadata.path", DEFAULT_API_PATH);
        configurationFactory.dataPath = extractor.getAsString("data.path", DEFAULT_API_PATH);
        configurationFactory.protocol = extractor.getAsString("protocol", DEFAULT_PROTOCOL);
        configurationFactory.connectTimeoutMillis = extractor.getAsInt("connection.timeout", 1000);
        configurationFactory.readTimeoutMillis = extractor.getAsInt("read.timeout", 1000);
        configurationFactory.pingTimeoutMillis = extractor.getAsLong("ping.timeout", 600000L);
        configurationFactory.ignoreSSLErrors = extractor.getAsBoolean("ssl.errors.ignore", false);
        configurationFactory.skipStreamingControl = extractor.getAsBoolean("streaming.control.skip", false);
        configurationFactory.enableGzipCompression = extractor.getAsBoolean("compression.gzip.enable", false);
        configurationFactory.userAgent = extractor.getAsString("user.agent", DEFAULT_USERNAME);
        return configurationFactory;
    }

    public ClientConfiguration createClientConfiguration() {
        return ClientConfiguration.builder(this.buildTimeSeriesUrl(), this.username, this.password).connectTimeoutMillis(this.connectTimeoutMillis).readTimeoutMillis(this.readTimeoutMillis).pingTimeoutMillis(this.pingTimeoutMillis).ignoreSSLErrors(this.ignoreSSLErrors).skipStreamingControl(this.skipStreamingControl).enableBatchCompression(this.enableGzipCompression).userAgent(this.userAgent).build();
    }

    private String buildMetaDataUrl() {
        return this.protocol + "://" + this.serverName + ":" + this.serverPort + this.metadataPath;
    }

    private String buildTimeSeriesUrl() {
        return this.protocol + "://" + this.serverName + ":" + this.serverPort + this.dataPath;
    }
}

