/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;

class RequestProcessor<T> {
    private Type type;
    private T command;

    private RequestProcessor(Type type, T command) {
        this.type = type;
        this.command = command;
    }

    public Response process(Invocation.Builder request, MediaType mediaType, boolean useCompression) {
        request = request.accept(new String[]{"application/json"});
        if (this.type == Type.DELETE) {
            return request.delete();
        }
        if (useCompression) {
            return request.acceptEncoding(new String[]{"gzip"}).method(this.type.name(), Entity.entity(this.command, (Variant)new Variant(mediaType, (String)null, "gzip")));
        }
        return request.method(this.type.name(), Entity.entity(this.command, (MediaType)mediaType));
    }

    public static <T> RequestProcessor<T> post(T command) {
        return new RequestProcessor<T>(Type.POST, command);
    }

    public static <T> RequestProcessor<T> put(T command) {
        return new RequestProcessor<T>(Type.PUT, command);
    }

    public static <T> RequestProcessor<T> patch(T command) {
        return new RequestProcessor<T>(Type.PATCH, command);
    }

    public static <T> RequestProcessor<T> delete() {
        return new RequestProcessor<Object>(Type.DELETE, null);
    }

    public static enum Type {
        POST,
        PUT,
        PATCH,
        DELETE;

    }
}

