/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.network;

import com.axibase.tsd.network.PlainCommand;
import com.axibase.tsd.util.AtsdUtil;
import java.util.Collections;
import java.util.Map;

public abstract class AbstractInsertCommand
implements PlainCommand {
    private final String commandName;
    protected final String entityName;
    private final Long timeMillis;
    private final String isoDate;
    protected final Map<String, String> tags;

    public AbstractInsertCommand(String commandName, String entityName, Long timeMillis, String isoDate, Map<String, String> tags) {
        this.commandName = commandName;
        AtsdUtil.checkEntityIsEmpty(entityName);
        this.entityName = entityName;
        this.timeMillis = timeMillis;
        this.isoDate = isoDate;
        this.tags = tags == null ? Collections.emptyMap() : tags;
    }

    @Override
    public final String compose() {
        StringBuilder sb = new StringBuilder(this.commandName).append(' ').append("e:").append(AbstractInsertCommand.handleName(this.entityName));
        if (this.timeMillis != null) {
            sb.append(' ').append("ms:").append(this.timeMillis);
        }
        if (this.isoDate != null) {
            sb.append(' ').append("d:").append(this.isoDate);
        }
        AbstractInsertCommand.appendKeysAndValues(sb, " t:", this.tags);
        this.appendValues(sb);
        return sb.append('\n').toString();
    }

    protected static void appendKeysAndValues(StringBuilder sb, String prefix, Map<String, String> map) {
        for (Map.Entry<String, String> tagNameAndValue : map.entrySet()) {
            sb.append(prefix).append(AbstractInsertCommand.handleName(tagNameAndValue.getKey())).append('=').append(AbstractInsertCommand.handleStringValue(tagNameAndValue.getValue()));
        }
    }

    protected static String handleStringValue(String value) {
        if (value == null) {
            return "null";
        }
        return '\"' + value.replace("\"", "\"\"") + '\"';
    }

    protected static String handleName(String key) {
        if (key == null) {
            return "null";
        }
        if (key.indexOf(34) != -1) {
            return '\"' + key.replace("\"", "\"\"") + '\"';
        }
        if (key.indexOf(61) != -1) {
            return '\"' + key + '\"';
        }
        return key;
    }

    protected abstract void appendValues(StringBuilder var1);
}

