/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.model.system.ServerError;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

final class AtsdServerMessageFactory {
    private static final Map<String, String> AUTH_DICT = AtsdServerMessageFactory.authDictionary();

    private AtsdServerMessageFactory() {
    }

    static String from(ServerError serverError) {
        String message = serverError.getMessage();
        return StringUtils.defaultString((String)AUTH_DICT.get(message), (String)message);
    }

    private static Map<String, String> authDictionary() {
        HashMap<String, String> dict = new HashMap<String, String>();
        dict.put("code 01", "General Server Error");
        dict.put("code 02", "Username Not Found");
        dict.put("code 03", "Bad Credentials");
        dict.put("code 04", "Disabled LDAP Service");
        dict.put("code 05", "Corrupted Configuration");
        dict.put("code 06", "MS Active Directory");
        dict.put("code 07", "Account Disabled");
        dict.put("code 08", "Account Expired");
        dict.put("code 09", "Account Locked");
        dict.put("code 10", "Logon Not Permitted At Time");
        dict.put("code 11", "Logon Not Permitted At Workstation");
        dict.put("code 12", "Password Expired");
        dict.put("code 13", "Password Reset Required");
        dict.put("code 14", "Wrong IP Address");
        dict.put("code 15", "Access Denied");
        return Collections.unmodifiableMap(dict);
    }
}

