/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.example;

import com.axibase.tsd.client.ClientConfigurationFactory;
import com.axibase.tsd.client.DataService;
import com.axibase.tsd.client.HttpClientManager;
import com.axibase.tsd.client.MetaDataService;
import com.axibase.tsd.model.data.series.Sample;
import com.axibase.tsd.model.data.series.Series;
import com.axibase.tsd.model.system.ClientConfiguration;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAtsdClientExample {
    protected Logger logger = LoggerFactory.getLogger(AbstractAtsdClientExample.class);
    protected DataService dataService;
    protected MetaDataService metaDataService;

    public DateFormat getDateFormat() {
        return new ISO8601DateFormat();
    }

    public void setDataService(DataService dataService) {
        this.dataService = dataService;
    }

    public void setMetaDataService(MetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    protected void configure() {
        this.logger.info("Getting Started with Axibase TSD");
        ClientConfiguration clientConfiguration = ClientConfigurationFactory.createInstance().createClientConfiguration();
        this.logger.info("Connecting to ATSD: " + clientConfiguration.getMetadataUrl());
        HttpClientManager httpClientManager = new HttpClientManager(clientConfiguration);
        this.dataService = new DataService(httpClientManager);
        this.metaDataService = new MetaDataService(httpClientManager);
    }

    protected void pureJavaConfigure() {
        ClientConfigurationFactory configurationFactory = new ClientConfigurationFactory("http", "writeyourownservername.com", 8088, "/api/v1", "/api/v1", "username", "pwd", 3000, 3000, 600000L, false, false, false);
        ClientConfiguration clientConfiguration = configurationFactory.createClientConfiguration();
        this.logger.info("Connecting to ATSD: " + clientConfiguration.getMetadataUrl());
        HttpClientManager httpClientManager = new HttpClientManager(clientConfiguration);
        GenericObjectPoolConfig objectPoolConfig = new GenericObjectPoolConfig();
        objectPoolConfig.setMaxTotal(5);
        objectPoolConfig.setMaxIdle(5);
        httpClientManager.setObjectPoolConfig(objectPoolConfig);
        httpClientManager.setBorrowMaxWaitMillis(1000);
        this.dataService = new DataService(httpClientManager);
        this.metaDataService = new MetaDataService(httpClientManager);
    }

    protected String toISODate(long time) {
        return this.getDateFormat().format(new Date(time));
    }

    protected void print(Series series) {
        this.logger.info("Time Sample Key: " + series.getTimeSeriesKey());
        List<Sample> data = series.getData();
        for (Sample sample : data) {
            long ts = sample.getTimeMillis();
            this.logger.info(this.toISODate(ts) + "\t" + sample.getNumericValueAsDouble() + (StringUtils.isNotEmpty((CharSequence)sample.getTextValue()) ? "\t" + sample.getTextValue() : ""));
        }
    }
}

