/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.permissions;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum Role {
    API_DATA_READ,
    API_DATA_WRITE,
    API_META_READ,
    API_META_WRITE,
    USER,
    EDITOR,
    ENTITY_GROUP_ADMIN,
    ADMIN;

    public static final String ROLE_PREFIX = "ROLE_";

    @JsonCreator
    public static Role forValue(String value) {
        for (Role role : Role.values()) {
            if (value.startsWith(ROLE_PREFIX)) {
                String roleName = role.name();
                if (ROLE_PREFIX.length() + roleName.length() != value.length() || !value.endsWith(roleName)) continue;
                return role;
            }
            throw new IllegalArgumentException("Role should starts with ROLE_");
        }
        throw new IllegalArgumentException(String.format("%s - incorrect role value", value));
    }
}

