/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.example;

import com.axibase.tsd.example.AbstractAtsdClientExample;
import com.axibase.tsd.model.data.command.GetSeriesQuery;
import com.axibase.tsd.model.data.command.SimpleAggregateMatcher;
import com.axibase.tsd.model.data.series.Interpolate;
import com.axibase.tsd.model.data.series.Interval;
import com.axibase.tsd.model.data.series.IntervalUnit;
import com.axibase.tsd.model.data.series.Series;
import com.axibase.tsd.model.data.series.aggregate.AggregateType;
import com.axibase.tsd.model.meta.EntityAndTags;
import com.axibase.tsd.model.meta.Metric;
import java.util.List;
import java.util.Map;

public class AtsdClientReadExample
extends AbstractAtsdClientExample {
    public static void main(String[] args) {
        AtsdClientReadExample atsdClientReadExample = new AtsdClientReadExample();
        atsdClientReadExample.configure();
        atsdClientReadExample.printMetaDataAndData();
    }

    private void printMetaDataAndData() {
        String metricExample = "jvm_memory_used_percent";
        Metric metric = this.metaDataService.retrieveMetric(metricExample);
        if (metric == null) {
            this.logger.info("Unknown metric: " + metricExample);
            return;
        }
        List<EntityAndTags> entityAndTagsList = this.metaDataService.retrieveEntityAndTags(metric.getName(), null);
        this.logger.info("===Metric MetaData===");
        this.logger.info("Metric: " + metric);
        for (EntityAndTags entityAndTags : entityAndTagsList) {
            String entityName = entityAndTags.getEntityName();
            this.logger.info("\n===Entity MetaData===");
            this.logger.info("Entity: " + entityName);
            Map<String, String> tags = entityAndTags.getTags();
            this.logger.info("===Tags===");
            for (Map.Entry<String, String> tagAndValue : tags.entrySet()) {
                this.logger.info("\t" + tagAndValue.getKey() + " : " + tagAndValue.getValue());
            }
            this.logger.info("===Sample===");
            GetSeriesQuery command = new GetSeriesQuery(entityName, metric.getName(), tags, System.currentTimeMillis() - 3600L, System.currentTimeMillis());
            command.setAggregateMatcher(new SimpleAggregateMatcher(new Interval(1, IntervalUnit.MINUTE), Interpolate.NONE, AggregateType.DETAIL, new AggregateType[0]));
            List<Series> getSeriesResults = this.dataService.retrieveSeries(command);
            for (Series getSeriesResult : getSeriesResults) {
                this.print(getSeriesResult);
            }
        }
    }
}

