/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.library.model;

import com.bandwidth.library.BandwidthRestClient;
import com.bandwidth.library.model.AccountInfo;
import com.bandwidth.library.model.AccountTransaction;
import com.bandwidth.library.model.BaseModelObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Account
extends BaseModelObject {
    public Account(BandwidthRestClient client, String parentUri) {
        super(client, parentUri, null);
    }

    public AccountInfo getAccountInfo() throws IOException {
        String uri = this.getUri();
        JSONObject jsonObject = this.client.getObject(uri);
        return new AccountInfo(this.client, uri, jsonObject);
    }

    public TransactionsQueryBuilder queryTransactionsBuilder() {
        return new TransactionsQueryBuilder();
    }

    private List<AccountTransaction> getTransactions(Map<String, Object> params) throws IOException {
        String transactionsUri = this.getAccountTransactionsUri();
        JSONArray array = this.client.getArray(transactionsUri, params);
        ArrayList<AccountTransaction> transactions = new ArrayList<AccountTransaction>();
        for (Object obj : array) {
            transactions.add(new AccountTransaction(this.client, transactionsUri, (JSONObject)obj));
        }
        return transactions;
    }

    private String getAccountTransactionsUri() {
        return StringUtils.join((Object[])new String[]{this.getUri(), "transactions"}, (char)'/');
    }

    @Override
    protected String getUri() {
        return StringUtils.join((Object[])new String[]{this.parentUri, "account"}, (char)'/');
    }

    public class TransactionsQueryBuilder {
        private Map<String, Object> params = new HashMap<String, Object>();

        public TransactionsQueryBuilder maxItems(int maxItems) {
            this.params.put("maxItems", maxItems);
            return this;
        }

        public TransactionsQueryBuilder fromDate(Date fromDate) {
            this.params.put("fromDate", BaseModelObject.dateFormat.format(fromDate));
            return this;
        }

        public TransactionsQueryBuilder toDate(Date toDate) {
            this.params.put("toDate", BaseModelObject.dateFormat.format(toDate));
            return this;
        }

        public TransactionsQueryBuilder type(String type) {
            this.params.put("type", type);
            return this;
        }

        public TransactionsQueryBuilder page(int page) {
            this.params.put("page", page);
            return this;
        }

        public TransactionsQueryBuilder size(int size) {
            this.params.put("size", size);
            return this;
        }

        public List<AccountTransaction> list() throws IOException {
            return Account.this.getTransactions(this.params);
        }
    }
}

