/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.library.model;

import com.bandwidth.library.BandwidthRestClient;
import com.bandwidth.library.model.BaseModelObject;
import com.bandwidth.library.model.Call;
import com.bandwidth.library.model.Gender;
import com.bandwidth.library.model.SentenceLocale;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Bridge
extends BaseModelObject {
    public Bridge(BandwidthRestClient client, String parentUri, JSONObject jsonObject) {
        super(client, parentUri, jsonObject);
    }

    public List<Call> getBridgeCalls() throws IOException {
        String callsPath = StringUtils.join((Object[])new String[]{this.getUri(), "calls"}, (char)'/');
        JSONArray jsonArray = this.client.getArray(callsPath, null);
        ArrayList<Call> callList = new ArrayList<Call>();
        for (Object obj : jsonArray) {
            callList.add(new Call(this.client, callsPath, (JSONObject)obj));
        }
        return callList;
    }

    public void setCallIds(String[] callIds) {
        this.putProperty("callIds", Arrays.asList(callIds));
    }

    public void setBridgeAudio(boolean bridgeAudio) {
        this.putProperty("bridgeAudio", bridgeAudio);
    }

    public void commit() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bridgeAudio", this.isBridgeAudio());
        String[] callIds = this.getCallIds();
        params.put("callIds", callIds == null ? Collections.emptyList() : Arrays.asList(callIds));
        this.client.post(this.getUri(), params);
    }

    public String getState() {
        return this.getPropertyAsString("state");
    }

    public String[] getCallIds() {
        return this.getPropertyAsStringArray("callIds");
    }

    public String getCalls() {
        return this.getPropertyAsString("calls");
    }

    public boolean isBridgeAudio() {
        return this.getPropertyAsBoolean("bridgeAudio");
    }

    public Date getCompletedTime() {
        return this.getPropertyAsDate("completedTime");
    }

    public Date getCreatedTime() {
        return this.getPropertyAsDate("createdTime");
    }

    public Date getActivatedTime() {
        return this.getPropertyAsDate("activatedTime");
    }

    public NewBridgeAudioBuilder newBridgeAudioBuilder() {
        return new NewBridgeAudioBuilder();
    }

    public void stopAudioFilePlaying() throws IOException {
        new NewBridgeAudioBuilder().fileUrl("").create();
    }

    public void stopSentence() throws IOException {
        new NewBridgeAudioBuilder().sentence("").create();
    }

    private void createAudio(Map<String, Object> params) throws IOException {
        String audioPath = StringUtils.join((Object[])new String[]{this.getUri(), "audio"}, (char)'/');
        this.client.post(audioPath, params);
    }

    public String toString() {
        return "Bridge{id='" + this.getId() + '\'' + ", state=" + this.getState() + ", callIds=" + Arrays.toString(this.getCallIds()) + ", calls='" + this.getCalls() + '\'' + ", bridgeAudio=" + this.isBridgeAudio() + ", completedTime=" + this.getCompletedTime() + ", createdTime=" + this.getCreatedTime() + ", activatedTime=" + this.getActivatedTime() + '}';
    }

    public class NewBridgeAudioBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public NewBridgeAudioBuilder fileUrl(String fileUrl) {
            this.params.put("fileUrl", fileUrl);
            return this;
        }

        public NewBridgeAudioBuilder sentence(String sentence) {
            this.params.put("sentence", sentence);
            return this;
        }

        public NewBridgeAudioBuilder gender(Gender gender) {
            this.params.put("gender", gender.name());
            return this;
        }

        public NewBridgeAudioBuilder locale(SentenceLocale locale) {
            this.params.put("locale", locale.restValue);
            return this;
        }

        public NewBridgeAudioBuilder voice(String voice) {
            this.params.put("voice", voice);
            return this;
        }

        public NewBridgeAudioBuilder loopEnabled(boolean loopEnabled) {
            this.params.put("loopEnabled", String.valueOf(loopEnabled));
            return this;
        }

        public void create() throws IOException {
            Bridge.this.createAudio(this.params);
        }
    }
}

