/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.library.model;

import com.bandwidth.library.BandwidthRestClient;
import com.bandwidth.library.model.BaseModelObject;
import com.bandwidth.library.model.Bridge;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Bridges
extends BaseModelObject {
    public Bridges(BandwidthRestClient client, String parentUri) {
        super(client, parentUri, null);
    }

    public List<Bridge> getBridges() throws IOException {
        JSONArray array = this.client.getArray(this.getUri(), null);
        String bridgesUri = this.getUri();
        ArrayList<Bridge> bridges = new ArrayList<Bridge>();
        for (Object obj : array) {
            bridges.add(new Bridge(this.client, bridgesUri, (JSONObject)obj));
        }
        return bridges;
    }

    public Bridge getBridge(String id) throws IOException {
        String bridgesUri = this.getUri();
        String eventPath = StringUtils.join((Object[])new String[]{bridgesUri, id}, (char)'/');
        JSONObject jsonObject = this.client.getObject(eventPath);
        return new Bridge(this.client, bridgesUri, jsonObject);
    }

    public NewBridgeBuilder newBridgeBuilder() {
        return new NewBridgeBuilder();
    }

    @Override
    protected String getUri() {
        return StringUtils.join((Object[])new String[]{this.parentUri, "bridges"}, (char)'/');
    }

    private Bridge createBridge(Map<String, Object> params) throws IOException {
        String bridgesUri = this.getUri();
        JSONObject jsonObject = this.client.create(bridgesUri, params);
        return new Bridge(this.client, bridgesUri, jsonObject);
    }

    public class NewBridgeBuilder {
        private Boolean bridgeAudio;
        private List<String> callIds = new ArrayList<String>();

        public NewBridgeBuilder bridgeAudio(boolean bridgeAudio) {
            this.bridgeAudio = bridgeAudio;
            return this;
        }

        public NewBridgeBuilder addCallId(String callId) {
            this.callIds.add(callId);
            return this;
        }

        public Bridge create() throws IOException {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (this.bridgeAudio != null) {
                params.put("bridgeAudio", String.valueOf(this.bridgeAudio));
            }
            if (!this.callIds.isEmpty()) {
                params.put("callIds", this.callIds);
            }
            return Bridges.this.createBridge(params);
        }
    }
}

