/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.library.model;

import com.bandwidth.library.BandwidthRestClient;
import com.bandwidth.library.model.BaseModelObject;
import com.bandwidth.library.model.ConferenceMember;
import com.bandwidth.library.model.Gender;
import com.bandwidth.library.model.SentenceLocale;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Conference
extends BaseModelObject {
    public Conference(BandwidthRestClient client, String parentUri, JSONObject jsonObject) {
        super(client, parentUri, jsonObject);
    }

    public String getFrom() {
        return this.getPropertyAsString("from");
    }

    public String getCallbackUrl() {
        return this.getPropertyAsString("callbackUrl");
    }

    public String getFallbackUrl() {
        return this.getPropertyAsString("fallbackUrl");
    }

    public String getState() {
        return this.getPropertyAsString("state");
    }

    public Long getActiveMembers() {
        return this.getPropertyAsLong("activeMembers");
    }

    public Long getCallbackTimeout() {
        return this.getPropertyAsLong("callbackTimeout");
    }

    public Date getCompletedTime() {
        return this.getPropertyAsDate("completedTime");
    }

    public Date getCreatedTime() {
        return this.getPropertyAsDate("createdTime");
    }

    public void complete() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("state", "completed");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = this.client.getObject(uri);
        this.updateProperties(jsonObject);
    }

    public void mute() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mute", String.valueOf(true));
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = this.client.getObject(uri);
        this.updateProperties(jsonObject);
    }

    public List<ConferenceMember> getMembers() throws IOException {
        String membersPath = StringUtils.join((Object[])new String[]{this.getUri(), "members"}, (char)'/');
        JSONArray array = this.client.getArray(membersPath, null);
        ArrayList<ConferenceMember> members = new ArrayList<ConferenceMember>();
        for (Object obj : array) {
            members.add(new ConferenceMember(this.client, membersPath, (JSONObject)obj));
        }
        return members;
    }

    public ConferenceAudioBuilder conferenceAudioBuilder() {
        return new ConferenceAudioBuilder();
    }

    private void createConferenceAudio(Map<String, Object> params) throws IOException {
        String audioPath = StringUtils.join((Object[])new String[]{this.getUri(), "audio"}, (char)'/');
        this.client.post(audioPath, params);
    }

    public String toString() {
        return "Conference{id='" + this.getId() + '\'' + ", from='" + this.getFrom() + '\'' + ", callbackUrl='" + this.getCallbackUrl() + '\'' + ", fallbackUrl='" + this.getFallbackUrl() + '\'' + ", state=" + this.getState() + ", activeMembers=" + this.getActiveMembers() + ", callbackTimeout=" + this.getCallbackTimeout() + ", completedTime=" + this.getCompletedTime() + ", createdTime=" + this.getCreatedTime() + '}';
    }

    public class ConferenceAudioBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public ConferenceAudioBuilder fileUrl(String fileUrl) {
            this.params.put("fileUrl", fileUrl);
            return this;
        }

        public ConferenceAudioBuilder sentence(String sentence) {
            this.params.put("sentence", sentence);
            return this;
        }

        public ConferenceAudioBuilder gender(Gender gender) {
            this.params.put("gender", gender.name());
            return this;
        }

        public ConferenceAudioBuilder locale(SentenceLocale locale) {
            this.params.put("locale", locale.restValue);
            return this;
        }

        public ConferenceAudioBuilder voice(String voice) {
            this.params.put("voice", voice);
            return this;
        }

        public void create() throws IOException {
            Conference.this.createConferenceAudio(this.params);
        }
    }
}

