/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.library.model;

import com.bandwidth.library.BandwidthRestClient;
import com.bandwidth.library.model.BaseModelObject;
import com.bandwidth.library.model.Conference;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;

public class Conferences
extends BaseModelObject {
    public Conferences(BandwidthRestClient client, String parentUri) {
        super(client, parentUri, null);
    }

    public Conference getConference(String id) throws IOException {
        String conferencesUri = this.getUri();
        String conferenceUri = StringUtils.join((Object[])new String[]{conferencesUri, id}, (char)'/');
        JSONObject jsonObject = this.client.getObject(conferenceUri);
        return new Conference(this.client, conferencesUri, jsonObject);
    }

    public NewConferenceBuilder newConferenceBuilder() {
        return new NewConferenceBuilder();
    }

    @Override
    protected String getUri() {
        return StringUtils.join((Object[])new String[]{this.parentUri, "conferences"}, (char)'/');
    }

    private Conference createConference(Map<String, Object> params) throws IOException {
        String conferencesUri = this.getUri();
        JSONObject jsonObject = this.client.create(conferencesUri, params);
        return new Conference(this.client, conferencesUri, jsonObject);
    }

    public class NewConferenceBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public Conference create() throws IOException {
            return Conferences.this.createConference(this.params);
        }

        public NewConferenceBuilder from(String from) {
            this.params.put("from", from);
            return this;
        }

        public NewConferenceBuilder callbackUrl(String callbackUrl) {
            this.params.put("callbackUrl", callbackUrl);
            return this;
        }

        public NewConferenceBuilder fallbackUrl(String fallbackUrl) {
            this.params.put("fallbackUrl", fallbackUrl);
            return this;
        }

        public NewConferenceBuilder callbackTimeout(int callbackTimeout) {
            this.params.put("callbackTimeout", callbackTimeout);
            return this;
        }
    }
}

