/*
 * Decompiled with CFR 0.152.
 */
package com.mailchimp;

import com.mailchimp.MailChimpClientBuilder;
import com.mailchimp.domain.Batch;
import com.mailchimp.domain.Batches;
import com.mailchimp.domain.Campaign;
import com.mailchimp.domain.CampaignChecklist;
import com.mailchimp.domain.CampaignFolder;
import com.mailchimp.domain.CampaignFolders;
import com.mailchimp.domain.Campaigns;
import com.mailchimp.domain.CreateBatch;
import com.mailchimp.domain.ListMergeField;
import com.mailchimp.domain.ListMergeFields;
import com.mailchimp.domain.Member;
import com.mailchimp.domain.Members;
import com.mailchimp.domain.Root;
import com.mailchimp.domain.SearchMembers;
import com.mailchimp.domain.Segment;
import com.mailchimp.domain.SegmentCreate;
import com.mailchimp.domain.SegmentModified;
import com.mailchimp.domain.SegmentModify;
import com.mailchimp.domain.Segments;
import com.mailchimp.domain.SubscriberList;
import com.mailchimp.domain.SubscriberLists;
import com.mailchimp.domain.Template;
import com.mailchimp.domain.Templates;
import com.mailchimp.query.BatchesQuery;
import com.mailchimp.query.CampaignFoldersQuery;
import com.mailchimp.query.CampaignsQuery;
import com.mailchimp.query.ListMembersQuery;
import com.mailchimp.query.ListsQuery;
import com.mailchimp.query.TemplatesQuery;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;

public interface MailChimpClient {
    @RequestLine(value="GET /3.0/")
    public Root getRoot();

    @RequestLine(value="GET /3.0/lists/{list-id}/members/{subscriber-hash}")
    public Member getListMember(@Param(value="list-id") String var1, @Param(value="subscriber-hash") String var2);

    @RequestLine(value="POST /3.0/lists/{list-id}/members")
    public Member createListMember(@Param(value="list-id") String var1, Member var2);

    @RequestLine(value="PUT /3.0/lists/{list-id}/members/{subscriber-hash}")
    public Member updateListMember(@Param(value="list-id") String var1, @Param(value="subscriber-hash") String var2, Member var3);

    @RequestLine(value="DELETE /3.0/lists/{list-id}/members/{subscriber-hash}")
    public void removeListMember(@Param(value="list-id") String var1, @Param(value="subscriber-hash") String var2);

    @RequestLine(value="POST /3.0/lists/{list-id}/members/{subscriber-hash}/actions/delete-permanent")
    public void deleteMember(@Param(value="list-id") String var1, @Param(value="subscriber-hash") String var2);

    @RequestLine(value="POST /3.0/lists")
    public SubscriberList createList(SubscriberList var1);

    @RequestLine(value="DELETE /3.0/lists/{list-id}")
    public void removeList(@Param(value="list-id") String var1);

    @RequestLine(value="GET /3.0/lists/{list-id}")
    public SubscriberList getList(@Param(value="list-id") String var1);

    @RequestLine(value="GET /3.0/lists")
    public SubscriberLists getLists(@QueryMap ListsQuery var1);

    @RequestLine(value="GET /3.0/lists/{list-id}/members")
    public Members getListMembers(@Param(value="list-id") String var1, @QueryMap ListMembersQuery var2);

    @RequestLine(value="GET /3.0/lists/{list-id}/merge-fields")
    public ListMergeFields getListMergeFields(@Param(value="list-id") String var1);

    @RequestLine(value="POST /3.0/lists/{list-id}/merge-fields")
    public ListMergeField createMergeField(@Param(value="list-id") String var1, ListMergeField var2);

    @RequestLine(value="DELETE /3.0/lists/{list-id}/merge-fields/{merge-id}")
    public void removeListMergeField(@Param(value="list-id") String var1, @Param(value="merge-id") String var2);

    @RequestLine(value="POST /3.0/lists/{list-id}/segments")
    public Segment createSegment(@Param(value="list-id") String var1, SegmentCreate var2);

    @RequestLine(value="POST /3.0/lists/{list-id}/segments/{segment-id}")
    public SegmentModified modifySegment(@Param(value="list-id") String var1, @Param(value="segment-id") Integer var2, SegmentModify var3);

    @RequestLine(value="GET /3.0/lists/{list-id}/segments")
    public Segments getSegments(@Param(value="list-id") String var1);

    @RequestLine(value="GET /3.0/lists/{list-id}/segments/{segment-id}")
    public Segment getSegment(@Param(value="list-id") String var1, @Param(value="segment-id") Integer var2);

    @RequestLine(value="DELETE /3.0/lists/{list-id}/segments/{segment-id}")
    public void removeSegment(@Param(value="list-id") String var1, @Param(value="segment-id") Integer var2);

    @RequestLine(value="POST /3.0/batches")
    public Batch createBatch(CreateBatch var1);

    @RequestLine(value="GET /3.0/batches/{batch-id}")
    public Batch getBatch(@Param(value="batch-id") String var1);

    @RequestLine(value="GET /3.0/batches")
    public Batches getBatches(@QueryMap BatchesQuery var1);

    @RequestLine(value="DELETE /3.0/batches/{batch-id}")
    public void removeBatch(@Param(value="batch-id") String var1);

    @RequestLine(value="GET /3.0/search-members?query={query}")
    public SearchMembers searchMembers(@Param(value="query") String var1);

    @RequestLine(value="GET /3.0/search-members?query={query}&list_id={listId}")
    public SearchMembers searchMembers(@Param(value="query") String var1, @Param(value="listId") String var2);

    @RequestLine(value="GET /3.0/templates")
    public Templates getTemplates(@QueryMap TemplatesQuery var1);

    @RequestLine(value="GET /3.0/templates/{template-id}")
    public Template getTemplate(@Param(value="template-id") String var1);

    @RequestLine(value="GET /3.0/campaigns")
    public Campaigns getCampaigns(@QueryMap CampaignsQuery var1);

    @RequestLine(value="GET /3.0/campaigns/{campaign-id}")
    public Campaign getCampaign(@Param(value="campaign-id") String var1);

    @RequestLine(value="POST /3.0/campaigns")
    public Campaign createCampaign(Campaign var1);

    @RequestLine(value="GET /3.0/campaigns/{campaign_id}/send-checklist")
    public CampaignChecklist getSendChecklist(@Param(value="campaign_id") String var1);

    @RequestLine(value="POST /3.0/campaigns/{campaign_id}/actions/send")
    public void sendCampaign(@Param(value="campaign_id") String var1);

    @RequestLine(value="GET /3.0/campaign-folders")
    public CampaignFolders getCampaignFolders(@QueryMap CampaignFoldersQuery var1);

    @RequestLine(value="GET /3.0/campaign-folders/{folder_id}")
    public CampaignFolder getCampaignFolder(@Param(value="folder_id") String var1);

    @RequestLine(value="POST /3.0/campaign-folders")
    public CampaignFolder createCampaignFolder(@Param(value="name") String var1);

    @RequestLine(value="DELETE /3.0/campaign-folders/{folder_id}")
    public void deleteCampaignFolder(@Param(value="folder_id") String var1);

    public static MailChimpClientBuilder builder() {
        return new MailChimpClientBuilder();
    }
}

