/*
 * Decompiled with CFR 0.152.
 */
package com.mailchimp;

import com.mailchimp.MailChimpClient;
import com.mailchimp.MailChimpErrorDecoder;
import com.mailchimp.auth.OAuth2RequestInterceptor;
import com.mailchimp.jackson.JacksonDecoder;
import com.mailchimp.jackson.JacksonEncoder;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import java.util.Objects;

public class MailChimpClientBuilder {
    private Client client = new Client.Default(null, null);
    private Logger.Level logLevel = Logger.Level.NONE;
    private Logger logger = new Logger.NoOpLogger();
    private RequestInterceptor authRequestInterceptor;
    private String apiBase;

    public MailChimpClientBuilder withClient(Client client) {
        this.client = client;
        return this;
    }

    public MailChimpClientBuilder withLogLevel(Logger.Level logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public MailChimpClientBuilder withClient(Logger logger) {
        this.logger = logger;
        return this;
    }

    public MailChimpClientBuilder withBasicAuthentication(String apiKey) {
        this.authRequestInterceptor = new BasicAuthRequestInterceptor("anyString", apiKey);
        return this;
    }

    public MailChimpClientBuilder withOAuth2Authentication(String accessToken) {
        this.authRequestInterceptor = new OAuth2RequestInterceptor(accessToken);
        return this;
    }

    public MailChimpClientBuilder withApiBase(String apiBase) {
        this.apiBase = apiBase;
        return this;
    }

    public MailChimpClient build() {
        Objects.requireNonNull(this.apiBase, "apiBase is required");
        Objects.requireNonNull(this.authRequestInterceptor, "authRequestInterceptor is required");
        return (MailChimpClient)Feign.builder().decoder((Decoder)new JacksonDecoder()).encoder((Encoder)new JacksonEncoder()).errorDecoder((ErrorDecoder)new MailChimpErrorDecoder()).requestInterceptor(this.authRequestInterceptor).client(this.client).logger(this.logger).logLevel(this.logLevel).target(MailChimpClient.class, "https://" + this.apiBase + ".api.mailchimp.com");
    }
}

