/*
 * Decompiled with CFR 0.152.
 */
package com.mailchimp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mailchimp.MailChimpErrorException;
import com.mailchimp.domain.MailChimpError;
import feign.FeignException;
import feign.Response;
import feign.RetryableException;
import feign.codec.ErrorDecoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class MailChimpErrorDecoder
implements ErrorDecoder {
    private final ObjectMapper om = new ObjectMapper();

    public Exception decode(String methodKey, Response response) {
        if (response.status() == 400 || response.status() == 404 || response.status() == 500) {
            try {
                MailChimpError error = (MailChimpError)this.om.readValue(response.body().asInputStream(), MailChimpError.class);
                return new MailChimpErrorException(response.status(), response.reason(), error);
            }
            catch (Exception ex) {
                return FeignException.errorStatus((String)methodKey, (Response)response);
            }
        }
        if (response.status() == 503) {
            Date retryAfter = new RetryAfterDecoder().apply((String)this.firstOrNull(response.headers(), "Retry-After"));
            return new RetryableException(response.reason(), response.request().httpMethod(), retryAfter);
        }
        return new ErrorDecoder.Default().decode(methodKey, response);
    }

    private <T> T firstOrNull(Map<String, Collection<T>> map, String key) {
        if (map.containsKey(key) && !map.get(key).isEmpty()) {
            return map.get(key).iterator().next();
        }
        return null;
    }

    static class RetryAfterDecoder {
        static final DateFormat RFC822_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        private final DateFormat rfc822Format;

        RetryAfterDecoder() {
            this(RFC822_FORMAT);
        }

        RetryAfterDecoder(@NonNull DateFormat rfc822Format) {
            if (rfc822Format == null) {
                throw new NullPointerException("rfc822Format is marked @NonNull but is null");
            }
            this.rfc822Format = rfc822Format;
        }

        protected long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Date apply(String retryAfter) {
            if (retryAfter == null) {
                return null;
            }
            if (retryAfter.matches("^[0-9]+$")) {
                long deltaMillis = TimeUnit.SECONDS.toMillis(Long.parseLong(retryAfter));
                return new Date(this.currentTimeMillis() + deltaMillis);
            }
            DateFormat dateFormat = this.rfc822Format;
            synchronized (dateFormat) {
                try {
                    return this.rfc822Format.parse(retryAfter);
                }
                catch (ParseException ignored) {
                    return null;
                }
            }
        }
    }
}

