/*
 * Decompiled with CFR 0.152.
 */
package com.mailchimp.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.mailchimp.domain.SubscribeStatus;
import com.mailchimp.jackson.MailChimpZonedDateTimeDeserializer;
import com.mailchimp.jackson.MailChimpZonedDateTimeSerializer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Member {
    public static final String MERGEFIELD_FNAME = "FNAME";
    public static final String MERGEFIELD_LNAME = "LNAME";
    @JsonProperty
    private String id;
    @JsonProperty(value="email_address", required=true)
    protected String emailAddress;
    @JsonProperty(value="unique_email_id")
    private String uniqueEmailId;
    @JsonProperty(value="email_type")
    private EmailType emailType;
    @JsonProperty(value="status")
    private SubscribeStatus status;
    @JsonProperty(value="merge_fields")
    private Map<String, String> mergeFields;
    @JsonProperty(value="timestamp_signup")
    @JsonDeserialize(using=MailChimpZonedDateTimeDeserializer.class)
    @JsonSerialize(using=MailChimpZonedDateTimeSerializer.class)
    private ZonedDateTime timestampSignup;
    @JsonProperty(value="ip_opt")
    private String ipOpt;
    @JsonProperty(value="timestamp_opt")
    @JsonDeserialize(using=MailChimpZonedDateTimeDeserializer.class)
    @JsonSerialize(using=MailChimpZonedDateTimeSerializer.class)
    private ZonedDateTime timestampOpt;
    @JsonProperty(value="member_rating")
    private Integer memberRating;
    @JsonProperty(value="last_changed")
    @JsonDeserialize(using=MailChimpZonedDateTimeDeserializer.class)
    @JsonSerialize(using=MailChimpZonedDateTimeSerializer.class)
    private ZonedDateTime lastChanged;
    @JsonProperty
    private String language;
    @JsonProperty
    private boolean vip;
    @JsonProperty(value="email_client")
    private String emailClient;
    @JsonProperty(value="status_if_new")
    private SubscribeStatus statusIfNew;
    @JsonProperty(value="list_id")
    private String listId;
    @JsonProperty(value="interests")
    private Map<String, Boolean> interests;

    @JsonIgnore
    public String getSubscriberHash() {
        return Member.getSubscriberHash(this.emailAddress);
    }

    @JsonIgnore
    public static String getSubscriberHash(String email) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return Hex.encodeHexString((byte[])md.digest(email.toLowerCase().getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void putMergeField(String name, String value) {
        if (this.mergeFields == null) {
            this.mergeFields = new HashMap<String, String>();
        }
        this.mergeFields.put(name, value);
    }

    public static MemberBuilder builder() {
        return new MemberBuilder();
    }

    public Member(String id, String emailAddress, String uniqueEmailId, EmailType emailType, SubscribeStatus status, Map<String, String> mergeFields, ZonedDateTime timestampSignup, String ipOpt, ZonedDateTime timestampOpt, Integer memberRating, ZonedDateTime lastChanged, String language, boolean vip, String emailClient, SubscribeStatus statusIfNew, String listId, Map<String, Boolean> interests) {
        this.id = id;
        this.emailAddress = emailAddress;
        this.uniqueEmailId = uniqueEmailId;
        this.emailType = emailType;
        this.status = status;
        this.mergeFields = mergeFields;
        this.timestampSignup = timestampSignup;
        this.ipOpt = ipOpt;
        this.timestampOpt = timestampOpt;
        this.memberRating = memberRating;
        this.lastChanged = lastChanged;
        this.language = language;
        this.vip = vip;
        this.emailClient = emailClient;
        this.statusIfNew = statusIfNew;
        this.listId = listId;
        this.interests = interests;
    }

    public Member() {
    }

    public String getId() {
        return this.id;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Member setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    public String getUniqueEmailId() {
        return this.uniqueEmailId;
    }

    public EmailType getEmailType() {
        return this.emailType;
    }

    public Member setEmailType(EmailType emailType) {
        this.emailType = emailType;
        return this;
    }

    public SubscribeStatus getStatus() {
        return this.status;
    }

    public Member setStatus(SubscribeStatus status) {
        this.status = status;
        return this;
    }

    public Map<String, String> getMergeFields() {
        return this.mergeFields;
    }

    public Member setMergeFields(Map<String, String> mergeFields) {
        this.mergeFields = mergeFields;
        return this;
    }

    public ZonedDateTime getTimestampSignup() {
        return this.timestampSignup;
    }

    public Member setTimestampSignup(ZonedDateTime timestampSignup) {
        this.timestampSignup = timestampSignup;
        return this;
    }

    public String getIpOpt() {
        return this.ipOpt;
    }

    public ZonedDateTime getTimestampOpt() {
        return this.timestampOpt;
    }

    public Integer getMemberRating() {
        return this.memberRating;
    }

    public ZonedDateTime getLastChanged() {
        return this.lastChanged;
    }

    public Member setLastChanged(ZonedDateTime lastChanged) {
        this.lastChanged = lastChanged;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public Member setLanguage(String language) {
        this.language = language;
        return this;
    }

    public boolean isVip() {
        return this.vip;
    }

    public Member setVip(boolean vip) {
        this.vip = vip;
        return this;
    }

    public String getEmailClient() {
        return this.emailClient;
    }

    public Member setEmailClient(String emailClient) {
        this.emailClient = emailClient;
        return this;
    }

    public SubscribeStatus getStatusIfNew() {
        return this.statusIfNew;
    }

    public Member setStatusIfNew(SubscribeStatus statusIfNew) {
        this.statusIfNew = statusIfNew;
        return this;
    }

    public String getListId() {
        return this.listId;
    }

    public static class MemberBuilder {
        private String id;
        private String emailAddress;
        private String uniqueEmailId;
        private EmailType emailType;
        private SubscribeStatus status;
        private Map<String, String> mergeFields;
        private ZonedDateTime timestampSignup;
        private String ipOpt;
        private ZonedDateTime timestampOpt;
        private Integer memberRating;
        private ZonedDateTime lastChanged;
        private String language;
        private boolean vip;
        private String emailClient;
        private SubscribeStatus statusIfNew;
        private String listId;
        private Map<String, Boolean> interests;

        MemberBuilder() {
        }

        public MemberBuilder id(String id) {
            this.id = id;
            return this;
        }

        public MemberBuilder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public MemberBuilder uniqueEmailId(String uniqueEmailId) {
            this.uniqueEmailId = uniqueEmailId;
            return this;
        }

        public MemberBuilder emailType(EmailType emailType) {
            this.emailType = emailType;
            return this;
        }

        public MemberBuilder status(SubscribeStatus status) {
            this.status = status;
            return this;
        }

        public MemberBuilder mergeFields(Map<String, String> mergeFields) {
            this.mergeFields = mergeFields;
            return this;
        }

        public MemberBuilder timestampSignup(ZonedDateTime timestampSignup) {
            this.timestampSignup = timestampSignup;
            return this;
        }

        public MemberBuilder ipOpt(String ipOpt) {
            this.ipOpt = ipOpt;
            return this;
        }

        public MemberBuilder timestampOpt(ZonedDateTime timestampOpt) {
            this.timestampOpt = timestampOpt;
            return this;
        }

        public MemberBuilder memberRating(Integer memberRating) {
            this.memberRating = memberRating;
            return this;
        }

        public MemberBuilder lastChanged(ZonedDateTime lastChanged) {
            this.lastChanged = lastChanged;
            return this;
        }

        public MemberBuilder language(String language) {
            this.language = language;
            return this;
        }

        public MemberBuilder vip(boolean vip) {
            this.vip = vip;
            return this;
        }

        public MemberBuilder emailClient(String emailClient) {
            this.emailClient = emailClient;
            return this;
        }

        public MemberBuilder statusIfNew(SubscribeStatus statusIfNew) {
            this.statusIfNew = statusIfNew;
            return this;
        }

        public MemberBuilder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public MemberBuilder interests(Map<String, Boolean> interests) {
            this.interests = interests;
            return this;
        }

        public Member build() {
            return new Member(this.id, this.emailAddress, this.uniqueEmailId, this.emailType, this.status, this.mergeFields, this.timestampSignup, this.ipOpt, this.timestampOpt, this.memberRating, this.lastChanged, this.language, this.vip, this.emailClient, this.statusIfNew, this.listId, this.interests);
        }

        public String toString() {
            return "Member.MemberBuilder(id=" + this.id + ", emailAddress=" + this.emailAddress + ", uniqueEmailId=" + this.uniqueEmailId + ", emailType=" + (Object)((Object)this.emailType) + ", status=" + (Object)((Object)this.status) + ", mergeFields=" + this.mergeFields + ", timestampSignup=" + this.timestampSignup + ", ipOpt=" + this.ipOpt + ", timestampOpt=" + this.timestampOpt + ", memberRating=" + this.memberRating + ", lastChanged=" + this.lastChanged + ", language=" + this.language + ", vip=" + this.vip + ", emailClient=" + this.emailClient + ", statusIfNew=" + (Object)((Object)this.statusIfNew) + ", listId=" + this.listId + ", interests=" + this.interests + ")";
        }
    }

    public static class SubscriberStats {
        @JsonProperty(value="avg_open_rate")
        private int avgOpenRate;
        @JsonProperty(value="avg_click_rate")
        private int avgClickRate;

        public int getAvgOpenRate() {
            return this.avgOpenRate;
        }

        public int getAvgClickRate() {
            return this.avgClickRate;
        }
    }

    public static enum EmailType {
        html,
        text;

    }
}

