/*
 * Decompiled with CFR 0.152.
 */
package com.mailchimp.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public final class MailChimpZonedDateTimeDeserializer
extends JsonDeserializer<ZonedDateTime> {
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    public ZonedDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String stringDate = parser.getText();
        if (stringDate == null || stringDate.isEmpty()) {
            return null;
        }
        try {
            return ZonedDateTime.parse(stringDate, this.dateTimeFormatter);
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }
}

