/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.report.Attribute;
import com.belladati.sdk.report.AttributeValue;
import com.belladati.sdk.util.CachedList;
import com.fasterxml.jackson.databind.JsonNode;

class AttributeImpl
implements Attribute {
    private final BellaDatiServiceImpl service;
    private final String reportId;
    private final String name;
    private final String code;

    AttributeImpl(BellaDatiServiceImpl service, String reportId, JsonNode node) throws InvalidAttributeException {
        this.service = service;
        this.reportId = reportId;
        if (!node.hasNonNull("name") || !node.hasNonNull("code")) {
            throw new InvalidAttributeException(node);
        }
        this.name = node.get("name").asText();
        this.code = node.get("code").asText();
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public CachedList<AttributeValue> getValues() {
        return this.service.getAttributeValues(this.reportId, this.code);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeImpl) {
            return this.code.equals(((AttributeImpl)obj).code) && this.reportId.equals(((AttributeImpl)obj).reportId);
        }
        return false;
    }

    public int hashCode() {
        return this.code.hashCode() ^ this.reportId.hashCode();
    }

    class InvalidAttributeException
    extends Exception {
        private static final long serialVersionUID = -4920843734203654180L;

        public InvalidAttributeException(JsonNode node) {
            super("Invalid attribute JSON: " + node.toString());
        }
    }
}

