/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.BellaDatiConnection;
import com.belladati.sdk.BellaDatiService;
import com.belladati.sdk.auth.OAuthRequest;
import com.belladati.sdk.impl.BellaDatiClient;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.OAuthRequestImpl;
import com.belladati.sdk.impl.TokenHolder;
import java.util.Arrays;
import java.util.List;
import org.apache.http.message.BasicNameValuePair;

class BellaDatiConnectionImpl
implements BellaDatiConnection {
    private static final long serialVersionUID = -4137207765985769374L;
    private final BellaDatiClient client;

    BellaDatiConnectionImpl(String baseUrl, boolean trustSelfSigned) {
        this.client = new BellaDatiClient(baseUrl, trustSelfSigned);
    }

    public OAuthRequest oAuth(String consumerKey, String consumerSecret) {
        TokenHolder tokenHolder = new TokenHolder(consumerKey, consumerSecret);
        this.client.postToken("oauth/requestToken", tokenHolder);
        return new OAuthRequestImpl(this.client, tokenHolder);
    }

    public BellaDatiService xAuth(String consumerKey, String consumerSecret, String username, String password) {
        TokenHolder tokenHolder = new TokenHolder(consumerKey, consumerSecret);
        List<BasicNameValuePair> parameters = Arrays.asList(new BasicNameValuePair("x_auth_username", username), new BasicNameValuePair("x_auth_password", password));
        this.client.postToken("oauth/accessToken", tokenHolder, parameters);
        return new BellaDatiServiceImpl(this.client, tokenHolder);
    }

    public String toString() {
        return "Connection(server: " + this.client.getBaseUrl() + ")";
    }
}

