/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.exception.InternalConfigurationException;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.util.PaginatedList;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;

abstract class PaginatedListImpl<T>
implements PaginatedList<T> {
    protected final List<T> currentData = new ArrayList<T>();
    private final BellaDatiServiceImpl service;
    private final String relativeUrl;
    private final String field;
    private int firstPage = -1;
    private int page = -1;
    private int size = -1;

    PaginatedListImpl(BellaDatiServiceImpl service, String relativeUrl, String field) {
        this.service = service;
        this.relativeUrl = relativeUrl;
        this.field = field;
    }

    public Iterator<T> iterator() {
        return this.currentData.iterator();
    }

    public PaginatedList<T> load() {
        return this.loadFrom(this.relativeUrl);
    }

    public PaginatedList<T> load(int size) throws IllegalArgumentException {
        return this.load(0, size);
    }

    public PaginatedList<T> load(int page, int size) throws IllegalArgumentException {
        if (page < 0) {
            throw new IllegalArgumentException("Page must be >= 0, was " + page);
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be > 0, was " + size);
        }
        return this.loadFrom(this.buildUri(page, size).toString());
    }

    private URI buildUri(int page, int size) {
        try {
            return new URIBuilder(this.relativeUrl).addParameter("offset", "" + page * size).addParameter("size", "" + size).build();
        }
        catch (URISyntaxException e) {
            throw new InternalConfigurationException("Invalid URI", (Throwable)e);
        }
    }

    private PaginatedList<T> loadFrom(String parameterizedUri) {
        this.currentData.clear();
        this.addFrom(parameterizedUri);
        this.firstPage = this.page;
        return this;
    }

    private PaginatedList<T> addFrom(String parameterizedUri) {
        JsonNode json = this.service.loadJson(parameterizedUri);
        this.size = json.get("size").asInt();
        this.page = json.get("offset").asInt() / this.size;
        ArrayNode nodes = (ArrayNode)json.get(this.field);
        for (JsonNode node : nodes) {
            this.currentData.add(this.parse(this.service, node));
        }
        return this;
    }

    public PaginatedList<T> loadNext() {
        if (!this.isLoaded()) {
            return this.load();
        }
        if (!this.hasNextPage()) {
            return this;
        }
        return this.addFrom(this.buildUri(this.page + 1, this.size).toString());
    }

    public boolean isLoaded() {
        return this.size > 0 && this.page >= 0;
    }

    public boolean hasNextPage() {
        if (!this.isLoaded()) {
            return true;
        }
        return this.size * (this.page - this.firstPage + 1) == this.currentData.size();
    }

    public int getFirstLoadedPage() {
        if (!this.isLoaded()) {
            return -1;
        }
        return this.firstPage;
    }

    public int getLastLoadedPage() {
        if (!this.isLoaded()) {
            return -1;
        }
        return this.page;
    }

    public int getFirstLoadedIndex() {
        if (!this.isLoaded() || this.currentData.isEmpty()) {
            return -1;
        }
        return this.firstPage * this.size;
    }

    public int getLastLoadedIndex() {
        if (!this.isLoaded() || this.currentData.isEmpty()) {
            return -1;
        }
        return this.getFirstLoadedIndex() + this.currentData.size() - 1;
    }

    public int getPageSize() {
        return this.size;
    }

    public boolean contains(T element) {
        return this.currentData.contains(element);
    }

    public T get(int index) throws IndexOutOfBoundsException {
        return this.currentData.get(index - this.getFirstLoadedIndex());
    }

    public int indexOf(T element) {
        int dataIndex = this.currentData.indexOf(element);
        if (dataIndex < 0) {
            return -1;
        }
        return this.getFirstLoadedIndex() + dataIndex;
    }

    public boolean isEmpty() {
        return this.currentData.isEmpty();
    }

    public int size() {
        return this.currentData.size();
    }

    public List<T> toList() {
        return Collections.unmodifiableList(this.currentData);
    }

    public String toString() {
        return this.currentData.toString();
    }

    protected abstract T parse(BellaDatiServiceImpl var1, JsonNode var2);
}

