/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.exception.InternalConfigurationException;
import com.belladati.sdk.filter.Filter;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.ViewImpl;
import com.belladati.sdk.view.TableView;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import org.apache.http.client.utils.URIBuilder;

class TableViewImpl
extends ViewImpl
implements TableView {
    TableViewImpl(BellaDatiServiceImpl service, JsonNode node) throws ViewImpl.UnknownViewTypeException {
        super(service, node);
    }

    public TableView.Table loadContent(Filter<?> ... filters) {
        return (TableView.Table)super.loadContent(filters);
    }

    public TableView.Table loadContent(Collection<Filter<?>> filters) {
        return (TableView.Table)super.loadContent(filters);
    }

    static class TableImpl
    implements TableView.Table {
        private final BellaDatiServiceImpl service;
        private final String id;
        private final int rowCount;
        private final int columnCount;
        private final int leftHeaderColumnCount;
        private final int topHeaderRowCount;
        private final Collection<Filter<?>> filters;

        TableImpl(BellaDatiServiceImpl service, String id, JsonNode node) {
            this(service, id, node, Collections.emptyList());
        }

        TableImpl(BellaDatiServiceImpl service, String id, JsonNode node, Collection<Filter<?>> filters) {
            this.service = service;
            this.id = id;
            this.filters = filters;
            this.rowCount = node.hasNonNull("rowsCount") ? node.get("rowsCount").asInt() : 0;
            this.columnCount = node.hasNonNull("columnsCount") ? node.get("columnsCount").asInt() : 0;
            this.leftHeaderColumnCount = node.hasNonNull("leftHeaderColumnsCount") ? node.get("leftHeaderColumnsCount").asInt() : 0;
            this.topHeaderRowCount = node.hasNonNull("topHeaderRowsCount") ? node.get("topHeaderRowsCount").asInt() : 0;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public boolean hasLeftHeader() {
            return this.leftHeaderColumnCount > 0;
        }

        public boolean hasTopHeader() {
            return this.topHeaderRowCount > 0;
        }

        public JsonNode loadLeftHeader(int startRow, int endRow) throws IllegalArgumentException {
            if (startRow < 0) {
                throw new IllegalArgumentException("First row must be > 0");
            }
            if (endRow > this.getRowCount()) {
                throw new IllegalArgumentException("Last row must be <= row count");
            }
            if (startRow > endRow) {
                throw new IllegalArgumentException("First row must be <= last row");
            }
            try {
                URIBuilder builder = new URIBuilder("api/reports/views/" + this.id + "/table/leftHeader");
                builder.addParameter("rowsFrom", "" + startRow);
                builder.addParameter("rowsTo", "" + endRow);
                this.service.appendFilter(builder, this.filters);
                return this.service.loadJson(builder.build().toString());
            }
            catch (URISyntaxException e) {
                throw new InternalConfigurationException((Throwable)e);
            }
        }

        public JsonNode loadTopHeader(int startColumn, int endColumn) throws IllegalArgumentException {
            if (startColumn < 0) {
                throw new IllegalArgumentException("First column must be > 0");
            }
            if (endColumn > this.getColumnCount()) {
                throw new IllegalArgumentException("Last column must be <= column count");
            }
            if (startColumn > endColumn) {
                throw new IllegalArgumentException("First column must be <= last column");
            }
            try {
                URIBuilder builder = new URIBuilder("api/reports/views/" + this.id + "/table/topHeader");
                builder.addParameter("columnsFrom", "" + startColumn);
                builder.addParameter("columnsTo", "" + endColumn);
                this.service.appendFilter(builder, this.filters);
                return this.service.loadJson(builder.build().toString());
            }
            catch (URISyntaxException e) {
                throw new InternalConfigurationException((Throwable)e);
            }
        }

        public JsonNode loadData(int startRow, int endRow, int startColumn, int endColumn) throws IllegalArgumentException {
            if (startRow < 0) {
                throw new IllegalArgumentException("First row must be > 0");
            }
            if (endRow > this.getRowCount()) {
                throw new IllegalArgumentException("Last row must be <= row count");
            }
            if (startRow > endRow) {
                throw new IllegalArgumentException("First row must be <= last row");
            }
            if (startColumn < 0) {
                throw new IllegalArgumentException("First column must be > 0");
            }
            if (endColumn > this.getColumnCount()) {
                throw new IllegalArgumentException("Last column must be <= column count");
            }
            if (startColumn > endColumn) {
                throw new IllegalArgumentException("First column must be <= last column");
            }
            try {
                URIBuilder builder = new URIBuilder("api/reports/views/" + this.id + "/table/data");
                builder.addParameter("rowsFrom", "" + startRow);
                builder.addParameter("rowsTo", "" + endRow);
                builder.addParameter("columnsFrom", "" + startColumn);
                builder.addParameter("columnsTo", "" + endColumn);
                this.service.appendFilter(builder, this.filters);
                return this.service.loadJson(builder.build().toString());
            }
            catch (URISyntaxException e) {
                throw new InternalConfigurationException((Throwable)e);
            }
        }

        public String toString() {
            return "Table(id: " + this.id + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof TableImpl) {
                return this.id.equals(((TableImpl)obj).id) && this.filters.equals(((TableImpl)obj).filters);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

