/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import java.io.Serializable;
import java.util.Random;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;

class TokenHolder
implements Serializable {
    private static final long serialVersionUID = 8122702080702303615L;
    private static final Random RANDOM = new Random();
    private final String consumerKey;
    private final String consumerSecret;
    private String token;
    private String tokenSecret;

    TokenHolder(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    public OAuthConsumer createConsumer() {
        CommonsHttpOAuthConsumer consumer = new CommonsHttpOAuthConsumer(this.consumerKey, this.consumerSecret){
            private static final long serialVersionUID = 2077439267247908434L;

            protected String generateNonce() {
                return Long.toString(RANDOM.nextLong());
            }
        };
        consumer.setTokenWithSecret(this.token, this.tokenSecret);
        return consumer;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token, String tokenSecret) {
        this.token = token;
        this.tokenSecret = tokenSecret;
    }
}

