/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dataset.Attribute;
import com.belladati.sdk.dataset.AttributeType;
import com.belladati.sdk.exception.BellaDatiRuntimeException;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.report.AttributeValue;
import com.belladati.sdk.util.CachedList;
import com.fasterxml.jackson.databind.JsonNode;

class AttributeImpl
implements Attribute {
    private final BellaDatiServiceImpl service;
    private final String reportId;
    private final String id;
    private final String name;
    private final String code;
    private final AttributeType type;

    AttributeImpl(BellaDatiServiceImpl service, String reportId, JsonNode node) throws InvalidAttributeException {
        this.service = service;
        this.reportId = reportId;
        if (node.hasNonNull("id") && node.hasNonNull("name") && node.hasNonNull("code") && node.hasNonNull("type")) {
            this.id = node.get("id").asText();
            this.name = node.get("name").asText();
            this.code = node.get("code").asText();
            this.type = AttributeType.valueOfJson((String)node.get("type").asText());
            if (this.type == null) {
                throw new InvalidAttributeException(node);
            }
        } else {
            throw new InvalidAttributeException(node);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public AttributeType getType() {
        return this.type;
    }

    public CachedList<AttributeValue> getValues() {
        if (this.reportId == null) {
            throw new AttributeValueLoadException();
        }
        return this.service.getAttributeValues(this.reportId, this.code);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeImpl) {
            return this.id.equals(((AttributeImpl)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    class AttributeValueLoadException
    extends BellaDatiRuntimeException {
        private static final long serialVersionUID = 4392730653489014114L;

        public AttributeValueLoadException() {
            super("Value loading for data set attributes is currently unsupported.");
        }
    }

    class InvalidAttributeException
    extends Exception {
        private static final long serialVersionUID = -4920843734203654180L;

        public InvalidAttributeException(JsonNode node) {
            super("Invalid attribute JSON: " + node.toString());
        }
    }
}

