/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.BellaDatiService;
import com.belladati.sdk.dashboard.Dashboard;
import com.belladati.sdk.dashboard.DashboardInfo;
import com.belladati.sdk.dataset.DataSet;
import com.belladati.sdk.dataset.DataSetInfo;
import com.belladati.sdk.dataset.data.DataTable;
import com.belladati.sdk.dataset.source.DataSource;
import com.belladati.sdk.dataset.source.DataSourceImport;
import com.belladati.sdk.dataset.source.DataSourcePendingImport;
import com.belladati.sdk.exception.InternalConfigurationException;
import com.belladati.sdk.exception.dataset.data.UnknownServerColumnException;
import com.belladati.sdk.exception.server.NotFoundException;
import com.belladati.sdk.exception.server.UnexpectedResponseException;
import com.belladati.sdk.filter.Filter;
import com.belladati.sdk.impl.AttributeValueImpl;
import com.belladati.sdk.impl.BellaDatiClient;
import com.belladati.sdk.impl.CachedListImpl;
import com.belladati.sdk.impl.CommentImpl;
import com.belladati.sdk.impl.DashboardImpl;
import com.belladati.sdk.impl.DashboardInfoImpl;
import com.belladati.sdk.impl.DataSetImpl;
import com.belladati.sdk.impl.DataSetInfoImpl;
import com.belladati.sdk.impl.DataSourceImpl;
import com.belladati.sdk.impl.DataSourceImportImpl;
import com.belladati.sdk.impl.DataSourcePendingImportImpl;
import com.belladati.sdk.impl.PaginatedIdListImpl;
import com.belladati.sdk.impl.PaginatedListImpl;
import com.belladati.sdk.impl.ReportImpl;
import com.belladati.sdk.impl.ReportInfoImpl;
import com.belladati.sdk.impl.TokenHolder;
import com.belladati.sdk.impl.UserImpl;
import com.belladati.sdk.impl.ViewLoaderImpl;
import com.belladati.sdk.intervals.DateUnit;
import com.belladati.sdk.intervals.Interval;
import com.belladati.sdk.intervals.TimeUnit;
import com.belladati.sdk.report.AttributeValue;
import com.belladati.sdk.report.Comment;
import com.belladati.sdk.report.Report;
import com.belladati.sdk.report.ReportInfo;
import com.belladati.sdk.user.User;
import com.belladati.sdk.util.CachedList;
import com.belladati.sdk.util.PaginatedIdList;
import com.belladati.sdk.util.PaginatedList;
import com.belladati.sdk.view.ViewLoader;
import com.belladati.sdk.view.ViewType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

class BellaDatiServiceImpl
implements BellaDatiService {
    private static final long serialVersionUID = 9054278401541000710L;
    public static final String DATE_TIME_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    final BellaDatiClient client;
    final TokenHolder tokenHolder;
    private final transient PaginatedIdList<DashboardInfo> dashboardList = new DashboardList();
    private final transient PaginatedIdList<ReportInfo> reportList = new ReportList();
    private final transient PaginatedIdList<DataSetInfo> dataSetList = new DataSetList();
    private final transient Map<String, PaginatedList<Comment>> commentLists = Collections.synchronizedMap(new HashMap());
    private final transient Map<String, Map<String, CachedListImpl<AttributeValue>>> reportAttributeValues = new HashMap<String, Map<String, CachedListImpl<AttributeValue>>>();
    private final transient Map<String, CachedListImpl<DataSource>> dataSourceList = new HashMap<String, CachedListImpl<DataSource>>();
    private final transient Map<String, CachedListImpl<DataSourceImport>> dataSourceImportList = new HashMap<String, CachedListImpl<DataSourceImport>>();

    BellaDatiServiceImpl(BellaDatiClient client, TokenHolder tokenHolder) {
        this.client = client;
        this.tokenHolder = tokenHolder;
    }

    public PaginatedIdList<DashboardInfo> getDashboardInfo() {
        return this.dashboardList;
    }

    public Dashboard loadDashboard(String id) {
        return new DashboardImpl(this, this.loadJson("api/dashboards/" + id));
    }

    public Object loadDashboardThumbnail(String id) throws IOException {
        return this.loadImage("api/dashboards/" + id + "/thumbnail");
    }

    public PaginatedIdList<ReportInfo> getReportInfo() {
        return this.reportList;
    }

    public Report loadReport(String id) {
        return new ReportImpl(this, this.loadJson("api/reports/" + id));
    }

    public Object loadReportThumbnail(String reportId) throws IOException {
        return this.loadImage("api/reports/" + reportId + "/thumbnail");
    }

    JsonNode loadJson(String uri) {
        return this.client.getJson(uri, this.tokenHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadImage(String relativeUrl) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.client.get(relativeUrl, this.tokenHolder));
        try {
            BufferedImage image = ImageIO.read(bais);
            if (image == null) {
                throw new IOException("Could not load image");
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            bais.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaginatedList<Comment> getReportComments(String reportId) {
        PaginatedList<Comment> existing = this.commentLists.get(reportId);
        if (existing != null) {
            return existing;
        }
        Map<String, PaginatedList<Comment>> map = this.commentLists;
        synchronized (map) {
            existing = this.commentLists.get(reportId);
            if (existing != null) {
                return existing;
            }
            PaginatedListImpl<Comment> newList = new PaginatedListImpl<Comment>(this, "api/reports/" + reportId + "/comments", "comments"){

                @Override
                protected Comment parse(BellaDatiServiceImpl service, JsonNode node) {
                    return new CommentImpl(service, node);
                }
            };
            this.commentLists.put(reportId, (PaginatedList<Comment>)newList);
            return newList;
        }
    }

    public void postComment(String reportId, String text) {
        this.client.post("api/reports/" + reportId + "/comments", this.tokenHolder, Collections.singletonList(new BasicNameValuePair("text", text)));
    }

    public Object loadViewContent(String viewId, ViewType viewType, Filter<?> ... filters) {
        return this.loadViewContent(viewId, viewType, Arrays.asList(filters));
    }

    public Object loadViewContent(String viewId, ViewType viewType, Collection<Filter<?>> filters) {
        return this.createViewLoader(viewId, viewType).addFilters(filters).loadContent();
    }

    public ViewLoader createViewLoader(String viewId, ViewType viewType) {
        return new ViewLoaderImpl(this, viewId, viewType);
    }

    public CachedList<DataSource> getDataSources(String id) throws NotFoundException {
        CachedListImpl<DataSource> list = this.dataSourceList.get(id);
        if (list == null) {
            list = new CachedListImpl<DataSource>(this, "api/dataSets/" + id + "/dataSources", "dataSources"){

                @Override
                protected DataSource parse(BellaDatiServiceImpl service, JsonNode node) throws CachedListImpl.ParseException {
                    return new DataSourceImpl(service, node);
                }
            };
            this.dataSourceList.put(id, list);
        }
        return list;
    }

    public CachedList<DataSourceImport> getDataSourceImports(String id) throws NotFoundException {
        CachedListImpl<DataSourceImport> list = this.dataSourceImportList.get(id);
        if (list == null) {
            list = new CachedListImpl<DataSourceImport>(this, "api/dataSets/dataSources/" + id + "/executions", "executions"){

                @Override
                protected DataSourceImport parse(BellaDatiServiceImpl service, JsonNode node) throws CachedListImpl.ParseException {
                    try {
                        return new DataSourceImportImpl(node);
                    }
                    catch (DataSourceImportImpl.InvalidDataSourceImportException e) {
                        throw new CachedListImpl.ParseException(node, (Throwable)e);
                    }
                }
            };
            this.dataSourceImportList.put(id, list);
        }
        return list;
    }

    public DataSourcePendingImport setupDataSourceImport(String id, Date date) {
        return new DataSourcePendingImportImpl(this, id, date);
    }

    URIBuilder appendFilter(URIBuilder builder, Collection<Filter<?>> filters) {
        if (filters.size() > 0) {
            ObjectNode filterNode = new ObjectMapper().createObjectNode();
            for (Filter<?> filter : filters) {
                filterNode.setAll(filter.toJson());
            }
            ObjectNode drilldownNode = new ObjectMapper().createObjectNode();
            drilldownNode.put("drilldown", (JsonNode)filterNode);
            builder.addParameter("filter", drilldownNode.toString());
        }
        return builder;
    }

    URIBuilder appendDateTime(URIBuilder builder, Interval<DateUnit> dateInterval, Interval<TimeUnit> timeInterval) {
        if (dateInterval != null || timeInterval != null) {
            ObjectNode dateTimeNode = new ObjectMapper().createObjectNode();
            if (dateInterval != null) {
                dateTimeNode.setAll(dateInterval.toJson());
            }
            if (timeInterval != null) {
                dateTimeNode.setAll(timeInterval.toJson());
            }
            builder.addParameter("dateTimeDefinition", dateTimeNode.toString());
        }
        return builder;
    }

    public synchronized CachedList<AttributeValue> getAttributeValues(String reportId, String attributeCode) {
        Map<String, CachedListImpl<AttributeValue>> attributeValues;
        CachedListImpl<AttributeValue> values;
        if (!this.reportAttributeValues.containsKey(reportId)) {
            this.reportAttributeValues.put(reportId, new HashMap());
        }
        if ((values = (attributeValues = this.reportAttributeValues.get(reportId)).get(attributeCode)) == null) {
            values = new CachedListImpl<AttributeValue>(this, "api/reports/" + reportId + "/filter/drilldownAttributeValues?code=" + attributeCode, "values"){

                @Override
                protected AttributeValue parse(BellaDatiServiceImpl service, JsonNode node) throws CachedListImpl.ParseException {
                    try {
                        return new AttributeValueImpl(node);
                    }
                    catch (AttributeValueImpl.InvalidAttributeValueException e) {
                        throw new CachedListImpl.ParseException(node, (Throwable)e);
                    }
                }
            };
            attributeValues.put(attributeCode, values);
        }
        return values;
    }

    public User loadUser(String userId) {
        return new UserImpl(this.loadJson("api/users/" + userId));
    }

    public Object loadUserImage(String userId) throws IOException {
        return this.loadImage("api/users/" + userId + "/image");
    }

    public String toString() {
        return "BellaDati Service(server: " + this.client.getBaseUrl() + ", key: " + this.tokenHolder.getConsumerKey() + ", token: " + this.tokenHolder.getToken() + ")";
    }

    public PaginatedIdList<DataSetInfo> getDataSetInfo() {
        return this.dataSetList;
    }

    public DataSet loadDataSet(String id) throws NotFoundException {
        return new DataSetImpl(this, this.loadJson("api/dataSets/" + id));
    }

    public void uploadData(String id, DataTable data) {
        List rows = data.getRows();
        if (rows.size() == 0) {
            return;
        }
        try {
            this.client.postUpload("api/import/" + id, this.tokenHolder, data.toJson().toString());
        }
        catch (UnexpectedResponseException e) {
            Pattern codePattern;
            Matcher codeMatcher;
            if (e.getResponseCode() == 400 && (codeMatcher = (codePattern = Pattern.compile(".*?'(.*?)'.*")).matcher(e.getResponseContent())).matches()) {
                throw new UnknownServerColumnException(id, codeMatcher.group(1));
            }
            throw new UnexpectedResponseException(e.getResponseCode(), e.getResponseContent(), (Throwable)e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Field dashboardList = this.getClass().getDeclaredField("dashboardList");
            dashboardList.setAccessible(true);
            dashboardList.set(this, new DashboardList());
            Field reportList = this.getClass().getDeclaredField("reportList");
            reportList.setAccessible(true);
            reportList.set(this, new ReportList());
            Field commentLists = this.getClass().getDeclaredField("commentLists");
            commentLists.setAccessible(true);
            commentLists.set(this, Collections.synchronizedMap(new HashMap()));
            Field reportAttributeValues = this.getClass().getDeclaredField("reportAttributeValues");
            reportAttributeValues.setAccessible(true);
            reportAttributeValues.set(this, new HashMap());
        }
        catch (NoSuchFieldException e) {
            throw new InternalConfigurationException("Failed to set service fields", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InternalConfigurationException("Failed to set service fields", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new InternalConfigurationException("Failed to set service fields", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new InternalConfigurationException("Failed to set service fields", (Throwable)e);
        }
    }

    private class DataSetList
    extends PaginatedIdListImpl<DataSetInfo> {
        public DataSetList() {
            super(BellaDatiServiceImpl.this, "api/dataSets", "dataSets");
        }

        @Override
        protected DataSetInfo parse(BellaDatiServiceImpl service, JsonNode node) {
            return new DataSetInfoImpl(service, node);
        }
    }

    private class ReportList
    extends PaginatedIdListImpl<ReportInfo> {
        public ReportList() {
            super(BellaDatiServiceImpl.this, "api/reports", "reports");
        }

        @Override
        protected ReportInfo parse(BellaDatiServiceImpl service, JsonNode node) {
            return new ReportInfoImpl(service, node);
        }
    }

    private class DashboardList
    extends PaginatedIdListImpl<DashboardInfo> {
        public DashboardList() {
            super(BellaDatiServiceImpl.this, "api/dashboards", "dashboards");
        }

        @Override
        protected DashboardInfo parse(BellaDatiServiceImpl service, JsonNode node) {
            return new DashboardInfoImpl(service, node);
        }
    }
}

