/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.UserInfoImpl;
import com.belladati.sdk.report.Comment;
import com.belladati.sdk.user.UserInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class CommentImpl
implements Comment {
    private final String text;
    private final Date date;
    private final UserInfo authorInfo;

    CommentImpl(BellaDatiServiceImpl service, JsonNode json) {
        this.text = json.hasNonNull("text") ? json.get("text").asText() : "";
        this.authorInfo = new UserInfoImpl(service, json.get("authorId").asText(), json.get("author").asText());
        if (json.hasNonNull("when")) {
            Date date;
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            try {
                date = format.parse(json.get("when").asText());
            }
            catch (ParseException e) {
                date = null;
            }
            this.date = date;
        } else {
            this.date = null;
        }
    }

    public String getText() {
        return this.text;
    }

    public Date getDateTime() {
        return this.date != null ? (Date)this.date.clone() : null;
    }

    public UserInfo getAuthorInfo() {
        return this.authorInfo;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommentImpl && this.authorInfo.equals(((CommentImpl)obj).authorInfo) && this.text.equals(((CommentImpl)obj).text)) {
            if (this.date == null) {
                return ((CommentImpl)obj).date == null;
            }
            return this.date.equals(((CommentImpl)obj).date);
        }
        return false;
    }

    public int hashCode() {
        return this.authorInfo.hashCode() ^ this.text.hashCode();
    }

    public String toString() {
        return this.text;
    }
}

