/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dataset.Attribute;
import com.belladati.sdk.dataset.DataSet;
import com.belladati.sdk.dataset.Indicator;
import com.belladati.sdk.dataset.data.DataTable;
import com.belladati.sdk.dataset.source.DataSource;
import com.belladati.sdk.impl.AttributeImpl;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.IndicatorImpl;
import com.belladati.sdk.impl.ReportInfoImpl;
import com.belladati.sdk.report.ReportInfo;
import com.belladati.sdk.util.CachedList;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

class DataSetImpl
implements DataSet {
    private final BellaDatiServiceImpl service;
    private final String id;
    private final String name;
    private final String description;
    private final String ownerName;
    private final Date lastChange;
    private final List<Attribute> attributes;
    private final List<Indicator> indicators;
    private final List<ReportInfo> reports;

    DataSetImpl(BellaDatiServiceImpl service, JsonNode json) {
        this.service = service;
        this.id = json.get("id").asText();
        this.name = json.get("name").asText();
        this.description = json.hasNonNull("description") ? json.get("description").asText() : "";
        this.ownerName = json.get("owner").asText();
        if (json.hasNonNull("lastChange")) {
            Date lastChange;
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            try {
                lastChange = format.parse(json.get("lastChange").asText());
            }
            catch (ParseException e) {
                lastChange = null;
            }
            this.lastChange = lastChange;
        } else {
            this.lastChange = null;
        }
        ArrayList<AttributeImpl> attributes = new ArrayList<AttributeImpl>();
        if (json.hasNonNull("attributes") && json.get("attributes") instanceof ArrayNode) {
            for (JsonNode attribute : (ArrayNode)json.get("attributes")) {
                try {
                    attributes.add(new AttributeImpl(service, null, attribute));
                }
                catch (AttributeImpl.InvalidAttributeException e) {}
            }
        }
        this.attributes = Collections.unmodifiableList(attributes);
        ArrayList<IndicatorImpl> indicators = new ArrayList<IndicatorImpl>();
        if (json.hasNonNull("indicators") && json.get("indicators") instanceof ArrayNode) {
            for (JsonNode indicator : (ArrayNode)json.get("indicators")) {
                try {
                    indicators.add(new IndicatorImpl(indicator));
                }
                catch (IndicatorImpl.InvalidIndicatorException e) {}
            }
        }
        this.indicators = Collections.unmodifiableList(indicators);
        ArrayList<ReportInfoImpl> reports = new ArrayList<ReportInfoImpl>();
        if (json.hasNonNull("reports") && json.get("reports") instanceof ArrayNode) {
            for (JsonNode report : (ArrayNode)json.get("reports")) {
                try {
                    reports.add(new ReportInfoImpl(service, report));
                }
                catch (ReportInfoImpl.InvalidReportException e) {}
            }
        }
        this.reports = Collections.unmodifiableList(reports);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Date getLastChange() {
        return this.lastChange != null ? (Date)this.lastChange.clone() : null;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataSetImpl) {
            return this.id.equals(((DataSetImpl)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<Indicator> getIndicators() {
        return this.indicators;
    }

    public List<ReportInfo> getReports() {
        return this.reports;
    }

    public CachedList<DataSource> getDataSources() {
        return this.service.getDataSources(this.id);
    }

    public DataTable createDataTable() {
        ArrayList<String> columns = new ArrayList<String>();
        for (Attribute attribute : this.attributes) {
            columns.add(attribute.getCode());
        }
        for (Indicator indicator : this.indicators) {
            columns.add(indicator.getCode());
        }
        return DataTable.createBasicInstance(columns);
    }

    public DataSet uploadData(DataTable data) {
        this.service.uploadData(this.id, data);
        return this;
    }
}

