/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dataset.data.OverwritePolicy;
import com.belladati.sdk.dataset.source.DataSourcePendingImport;
import com.belladati.sdk.dataset.source.ImportInterval;
import com.belladati.sdk.dataset.source.ImportIntervalUnit;
import com.belladati.sdk.exception.server.NotFoundException;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.DataSourceImportBaseImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import org.apache.http.message.BasicNameValuePair;

class DataSourcePendingImportImpl
extends DataSourceImportBaseImpl
implements DataSourcePendingImport {
    private final BellaDatiServiceImpl service;
    private final String sourceId;
    private OverwritePolicy overwritePolicy = OverwritePolicy.deleteNone();
    private boolean posted = false;

    DataSourcePendingImportImpl(BellaDatiServiceImpl service, String sourceId, Date date) {
        super("", date);
        this.service = service;
        this.sourceId = sourceId;
    }

    public boolean isOverwriting() {
        return !OverwritePolicy.deleteNone().equals(this.overwritePolicy);
    }

    public DataSourcePendingImport setOverwritePolicy(OverwritePolicy policy) throws IllegalStateException {
        if (this.posted) {
            throw new IllegalStateException("Import already submitted to server.");
        }
        this.overwritePolicy = policy == null ? OverwritePolicy.deleteNone() : policy;
        return this;
    }

    public OverwritePolicy getOverwritePolicy() {
        return this.overwritePolicy;
    }

    public DataSourcePendingImport setRepeatInterval(ImportIntervalUnit unit, int factor) throws IllegalStateException {
        if (this.posted) {
            throw new IllegalStateException("Import already submitted to server.");
        }
        this.interval = unit == null || factor <= 0 ? null : new DataSourceImportBaseImpl.ImportIntervalImpl(unit, factor);
        return this;
    }

    public JsonNode toJson() {
        ObjectNode node = new ObjectMapper().createObjectNode().put("when", new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(this.nextImport));
        if (this.isOverwriting()) {
            node.put("overwrite", this.overwritePolicy.toJson());
        }
        if (this.interval != null) {
            DataSourceImportBaseImpl.ImportPeriod period = this.findPeriod(this.interval);
            node.put("repeateInterval", period.name());
            if (period == DataSourceImportBaseImpl.ImportPeriod.CUSTOM) {
                node.put("customRepeateInterval", this.interval.getMinutes());
            }
        }
        return node;
    }

    public void post() throws NotFoundException, IllegalStateException {
        if (this.posted) {
            throw new IllegalStateException("Import already submitted to server.");
        }
        this.service.client.post("api/dataSets/dataSources/" + this.sourceId + "/schedule", this.service.tokenHolder, Collections.singletonList(new BasicNameValuePair("params", this.toJson().toString())));
        this.posted = true;
    }

    DataSourceImportBaseImpl.ImportPeriod findPeriod(ImportInterval interval) {
        for (DataSourceImportBaseImpl.ImportPeriod period : DataSourceImportBaseImpl.ImportPeriod.values()) {
            if (period.minutes != interval.getMinutes()) continue;
            return period;
        }
        return DataSourceImportBaseImpl.ImportPeriod.CUSTOM;
    }
}

