/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dataset.Indicator;
import com.belladati.sdk.dataset.IndicatorType;
import com.fasterxml.jackson.databind.JsonNode;

public class IndicatorImpl
implements Indicator {
    private final String id;
    private final String name;
    private final String code;
    private final String formula;
    private final IndicatorType type;

    IndicatorImpl(JsonNode node) throws InvalidIndicatorException {
        if (node.hasNonNull("id") && node.hasNonNull("name") && node.hasNonNull("type")) {
            this.id = node.get("id").asText();
            this.name = node.get("name").asText();
            this.type = IndicatorType.valueOfJson((String)node.get("type").asText());
            if (this.type == null) {
                throw new InvalidIndicatorException(node);
            }
            if (this.type == IndicatorType.DATA) {
                if (!node.hasNonNull("code")) {
                    throw new InvalidIndicatorException(node);
                }
                this.code = node.get("code").asText();
                this.formula = null;
            } else if (this.type == IndicatorType.FORMULA) {
                this.code = null;
                if (!node.hasNonNull("formula")) {
                    throw new InvalidIndicatorException(node);
                }
                this.formula = node.get("formula").asText();
            } else {
                this.code = null;
                this.formula = null;
            }
        } else {
            throw new InvalidIndicatorException(node);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public IndicatorType getType() {
        return this.type;
    }

    public String getFormula() {
        return this.formula;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IndicatorImpl) {
            return this.id.equals(((IndicatorImpl)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    class InvalidIndicatorException
    extends Exception {
        private static final long serialVersionUID = -4920843734203654180L;

        public InvalidIndicatorException(JsonNode node) {
            super("Invalid indicator JSON: " + node.toString());
        }
    }
}

