/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dataset.Attribute;
import com.belladati.sdk.dataset.DataSetInfo;
import com.belladati.sdk.impl.AttributeImpl;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.DataSetInfoImpl;
import com.belladati.sdk.impl.ViewImpl;
import com.belladati.sdk.report.Comment;
import com.belladati.sdk.report.Report;
import com.belladati.sdk.util.PaginatedList;
import com.belladati.sdk.view.View;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

class ReportImpl
implements Report {
    private final BellaDatiServiceImpl service;
    private final String id;
    private final String name;
    private final String description;
    private final String ownerName;
    private final Date lastChange;
    private final List<View> viewInfos;
    private final List<Attribute> attributes;
    private final DataSetInfo dataSet;

    ReportImpl(BellaDatiServiceImpl service, JsonNode json) {
        this.service = service;
        this.id = json.get("id").asText();
        this.name = json.get("name").asText();
        this.description = json.hasNonNull("description") ? json.get("description").asText() : "";
        this.ownerName = json.get("owner").asText();
        if (json.hasNonNull("lastChange")) {
            Date lastChange;
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            try {
                lastChange = format.parse(json.get("lastChange").asText());
            }
            catch (ParseException e) {
                lastChange = null;
            }
            this.lastChange = lastChange;
        } else {
            this.lastChange = null;
        }
        ArrayList<ViewImpl> viewInfos = new ArrayList<ViewImpl>();
        if (json.hasNonNull("views") && json.get("views") instanceof ArrayNode) {
            for (JsonNode view : (ArrayNode)json.get("views")) {
                try {
                    viewInfos.add(ViewImpl.buildView(service, view));
                }
                catch (ViewImpl.UnknownViewTypeException e) {}
            }
        }
        this.viewInfos = Collections.unmodifiableList(viewInfos);
        ArrayList<AttributeImpl> attributes = new ArrayList<AttributeImpl>();
        if (json.hasNonNull("dataSet") && json.get("dataSet").hasNonNull("drilldownAttributes") && json.get("dataSet").get("drilldownAttributes") instanceof ArrayNode) {
            for (JsonNode attribute : (ArrayNode)json.get("dataSet").get("drilldownAttributes")) {
                try {
                    attributes.add(new AttributeImpl(service, this.id, attribute));
                }
                catch (AttributeImpl.InvalidAttributeException e) {}
            }
        }
        this.attributes = Collections.unmodifiableList(attributes);
        this.dataSet = json.hasNonNull("dataSet") && json.get("dataSet").hasNonNull("id") ? new DataSetInfoImpl(service, json.get("dataSet")) : null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Date getLastChange() {
        return this.lastChange != null ? (Date)this.lastChange.clone() : null;
    }

    public List<View> getViews() {
        return this.viewInfos;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public PaginatedList<Comment> getComments() {
        return this.service.getReportComments(this.id);
    }

    public void postComment(String text) {
        this.service.postComment(this.id, text);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReportImpl) {
            return this.id.equals(((ReportImpl)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public DataSetInfo getDataSet() {
        return this.dataSet;
    }
}

