/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.exception.BellaDatiRuntimeException;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.report.Comment;
import com.belladati.sdk.report.Report;
import com.belladati.sdk.report.ReportInfo;
import com.belladati.sdk.util.PaginatedList;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class ReportInfoImpl
implements ReportInfo {
    private final BellaDatiServiceImpl service;
    private final String id;
    private final String name;
    private final String description;
    private final String ownerName;
    private final Date lastChange;

    ReportInfoImpl(BellaDatiServiceImpl service, JsonNode json) {
        if (!(json.hasNonNull("id") && json.hasNonNull("name") && json.hasNonNull("owner"))) {
            throw new InvalidReportException(json);
        }
        this.service = service;
        this.id = json.get("id").asText();
        this.name = json.get("name").asText();
        this.description = json.hasNonNull("description") ? json.get("description").asText() : "";
        this.ownerName = json.get("owner").asText();
        if (json.hasNonNull("lastChange")) {
            Date lastChange;
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            try {
                lastChange = format.parse(json.get("lastChange").asText());
            }
            catch (ParseException e) {
                lastChange = null;
            }
            this.lastChange = lastChange;
        } else {
            this.lastChange = null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Date getLastChange() {
        return this.lastChange != null ? (Date)this.lastChange.clone() : null;
    }

    public Report loadDetails() {
        return this.service.loadReport(this.id);
    }

    public Object loadThumbnail() throws IOException {
        return this.service.loadReportThumbnail(this.id);
    }

    public PaginatedList<Comment> getComments() {
        return this.service.getReportComments(this.id);
    }

    public void postComment(String text) {
        this.service.postComment(this.id, text);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReportInfoImpl) {
            return this.id.equals(((ReportInfoImpl)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    class InvalidReportException
    extends BellaDatiRuntimeException {
        private static final long serialVersionUID = -4920843734203654180L;

        public InvalidReportException(JsonNode node) {
            super("Invalid report JSON: " + node.toString());
        }
    }
}

