/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dataset.AttributeValue;
import com.fasterxml.jackson.databind.JsonNode;

class AttributeValueImpl
implements AttributeValue {
    private final String label;
    private final String value;

    AttributeValueImpl(JsonNode node) throws InvalidAttributeValueException {
        if (!node.hasNonNull("label") || !node.hasNonNull("value")) {
            throw new InvalidAttributeValueException(node);
        }
        this.label = node.get("label").asText();
        this.value = node.get("value").asText();
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeValue) {
            return this.value.equals(((AttributeValue)obj).getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    class InvalidAttributeValueException
    extends Exception {
        private static final long serialVersionUID = -4920843734203654180L;

        public InvalidAttributeValueException(JsonNode node) {
            super("Invalid attribute value JSON: " + node.toString());
        }
    }
}

