/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.exception.BellaDatiRuntimeException;
import com.belladati.sdk.exception.InternalConfigurationException;
import com.belladati.sdk.exception.auth.AuthorizationException;
import com.belladati.sdk.exception.auth.InvalidTimestampException;
import com.belladati.sdk.exception.server.InvalidJsonException;
import com.belladati.sdk.exception.server.UnexpectedResponseException;
import com.belladati.sdk.impl.TokenHolder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.ssl.SSLContext;
import oauth.signpost.OAuth;
import oauth.signpost.http.HttpParameters;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

class BellaDatiClient
implements Serializable {
    private static final long serialVersionUID = 9138881190417975299L;
    private final String baseUrl;
    private final boolean trustSelfSigned;
    private final transient CloseableHttpClient client;

    BellaDatiClient(String baseUrl, boolean trustSelfSigned) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        this.trustSelfSigned = trustSelfSigned;
        this.client = this.buildClient(trustSelfSigned);
    }

    private CloseableHttpClient buildClient(boolean trustSelfSigned) {
        try {
            SSLContext sslContext = !trustSelfSigned ? SSLContexts.createSystemDefault() : SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            int globalTimeout = this.readFromProperty("bdTimeout", 100000);
            int connectTimeout = this.readFromProperty("bdConnectTimeout", globalTimeout);
            int connectionRequestTimeout = this.readFromProperty("bdConnectionRequestTimeout", globalTimeout);
            int socketTimeout = this.readFromProperty("bdSocketTimeout", globalTimeout);
            RequestConfig requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
            CacheConfig cacheConfig = CacheConfig.copy((CacheConfig)CacheConfig.DEFAULT).setSharedCache(false).setMaxCacheEntries(1000).setMaxObjectSize(0x200000L).build();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build());
            int connectionLimit = this.readFromProperty("bdMaxConnections", 40);
            connManager.setMaxTotal(connectionLimit);
            connManager.setDefaultMaxPerRoute(connectionLimit);
            return CachingHttpClientBuilder.create().setCacheConfig(cacheConfig).setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connManager).build();
        }
        catch (GeneralSecurityException e) {
            throw new InternalConfigurationException("Failed to set up SSL context", (Throwable)e);
        }
    }

    private int readFromProperty(String property, int defaultValue) {
        try {
            return Integer.parseInt(System.getProperty(property));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public byte[] post(String relativeUrl, TokenHolder tokenHolder) {
        return this.post(relativeUrl, tokenHolder, null, null);
    }

    public byte[] post(String relativeUrl, TokenHolder tokenHolder, HttpParameters oauthParams) {
        return this.post(relativeUrl, tokenHolder, oauthParams, null);
    }

    public byte[] post(String relativeUrl, TokenHolder tokenHolder, List<? extends NameValuePair> parameters) {
        return this.post(relativeUrl, tokenHolder, null, parameters);
    }

    public byte[] post(String relativeUrl, TokenHolder tokenHolder, HttpParameters oauthParams, List<? extends NameValuePair> parameters) {
        HttpPost post = new HttpPost(this.baseUrl + relativeUrl);
        if (parameters != null) {
            try {
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Invalid URL encoding", e);
            }
        }
        return this.doRequest((HttpRequestBase)post, tokenHolder, oauthParams);
    }

    public byte[] postUpload(String relativeUrl, TokenHolder tokenHolder, String content) {
        HttpPost post = new HttpPost(this.baseUrl + relativeUrl);
        try {
            StringEntity entity = new StringEntity(content, "UTF-8");
            entity.setContentType("application/octet-stream");
            post.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid URL encoding", e);
        }
        return this.doRequest((HttpRequestBase)post, tokenHolder);
    }

    public byte[] postData(String relativeUrl, TokenHolder tokenHolder, byte[] content) {
        HttpPost post = new HttpPost(this.baseUrl + relativeUrl);
        ByteArrayEntity entity = new ByteArrayEntity(content);
        entity.setContentType("application/octet-stream");
        post.setEntity((HttpEntity)entity);
        return this.doRequest((HttpRequestBase)post, tokenHolder);
    }

    public TokenHolder postToken(String relativeUrl, TokenHolder tokenHolder) {
        return this.postToken(relativeUrl, tokenHolder, null, null);
    }

    public TokenHolder postToken(String relativeUrl, TokenHolder tokenHolder, HttpParameters oauthParams) {
        return this.postToken(relativeUrl, tokenHolder, oauthParams, null);
    }

    public TokenHolder postToken(String relativeUrl, TokenHolder tokenHolder, List<? extends NameValuePair> parameters) {
        return this.postToken(relativeUrl, tokenHolder, null, parameters);
    }

    public TokenHolder postToken(String relativeUrl, TokenHolder tokenHolder, HttpParameters oauthParams, List<? extends NameValuePair> parameters) {
        byte[] response = this.post(relativeUrl, tokenHolder, oauthParams, parameters);
        try {
            HttpParameters responseParams = OAuth.decodeForm((InputStream)new ByteArrayInputStream(response));
            String token = responseParams.getFirst((Object)"oauth_token");
            String tokenSecret = responseParams.getFirst((Object)"oauth_token_secret");
            tokenHolder.setToken(token, tokenSecret);
            return tokenHolder;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to load OAuth token from response", e);
        }
    }

    public byte[] get(String relativeUrl, TokenHolder tokenHolder) {
        return this.doRequest((HttpRequestBase)new HttpGet(this.baseUrl + relativeUrl), tokenHolder);
    }

    public JsonNode getJson(String relativeUrl, TokenHolder tokenHolder) {
        byte[] response = this.get(relativeUrl, tokenHolder);
        try {
            return new ObjectMapper().readTree(response);
        }
        catch (IOException e) {
            throw new InvalidJsonException("Could not parse JSON response, was " + new String(response), (Throwable)e);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    private byte[] doRequest(HttpRequestBase request, TokenHolder tokenHolder) {
        return this.doRequest(request, tokenHolder, null);
    }

    /*
     * Exception decompiling
     */
    private byte[] doRequest(HttpRequestBase request, TokenHolder tokenHolder, HttpParameters oauthParams) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BellaDatiRuntimeException buildException(int code, byte[] content, boolean hasToken) {
        try {
            HttpParameters oauthParams = OAuth.decodeForm((InputStream)new ByteArrayInputStream(content));
            if (oauthParams.containsKey((Object)"oauth_problem")) {
                String acceptable;
                String problem = oauthParams.getFirst((Object)"oauth_problem");
                if ("missing_consumer".equals(problem) || "invalid_consumer".equals(problem)) {
                    return new AuthorizationException(AuthorizationException.Reason.CONSUMER_KEY_UNKNOWN);
                }
                if ("invalid_signature".equals(problem) || "signature_invalid".equals(problem)) {
                    return new AuthorizationException(hasToken ? AuthorizationException.Reason.TOKEN_INVALID : AuthorizationException.Reason.CONSUMER_SECRET_INVALID);
                }
                if ("domain_expired".equals(problem)) {
                    return new AuthorizationException(AuthorizationException.Reason.DOMAIN_EXPIRED);
                }
                if ("missing_token".equals(problem) || "invalid_token".equals(problem)) {
                    return new AuthorizationException(AuthorizationException.Reason.TOKEN_INVALID);
                }
                if ("unauthorized_token".equals(problem)) {
                    return new AuthorizationException(AuthorizationException.Reason.TOKEN_UNAUTHORIZED);
                }
                if ("token_expired".equals(problem)) {
                    return new AuthorizationException(AuthorizationException.Reason.TOKEN_EXPIRED);
                }
                if ("x_auth_disabled".equals(problem)) {
                    return new AuthorizationException(AuthorizationException.Reason.X_AUTH_DISABLED);
                }
                if ("piccolo_not_enabled".equals(problem)) {
                    return new AuthorizationException(AuthorizationException.Reason.BD_MOBILE_DISABLED);
                }
                if ("missing_username".equals(problem) || "missing_password".equals(problem) || "invalid_credentials".equals(problem) || "permission_denied".equals(problem)) {
                    return new AuthorizationException(AuthorizationException.Reason.USER_CREDENTIALS_INVALID);
                }
                if ("account_locked".equals(problem) || "user_not_active".equals(problem)) {
                    return new AuthorizationException(AuthorizationException.Reason.USER_ACCOUNT_LOCKED);
                }
                if ("domain_restricted".equals(problem)) {
                    return new AuthorizationException(AuthorizationException.Reason.USER_DOMAIN_MISMATCH);
                }
                if ("timestamp_refused".equals(problem) && (acceptable = oauthParams.getFirst((Object)"oauth_acceptable_timestamps")) != null && acceptable.contains("-")) {
                    return new InvalidTimestampException(Long.parseLong(acceptable.split("-")[0]), Long.parseLong(acceptable.split("-")[1]));
                }
                return new AuthorizationException(AuthorizationException.Reason.OTHER, problem);
            }
            return new UnexpectedResponseException(code, new String(content));
        }
        catch (IOException e) {
            throw new UnexpectedResponseException(code, new String(content), (Throwable)e);
        }
    }

    private static byte[] readBytes(InputStream in) throws IOException {
        int len;
        byte[] buffer = new byte[128];
        ByteArrayOutputStream buf = new ByteArrayOutputStream(8192);
        while ((len = in.read(buffer, 0, buffer.length)) != -1) {
            buf.write(buffer, 0, len);
        }
        buf.flush();
        return buf.toByteArray();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Field client = this.getClass().getDeclaredField("client");
            client.setAccessible(true);
            client.set(this, this.buildClient(this.trustSelfSigned));
        }
        catch (NoSuchFieldException e) {
            throw new InternalConfigurationException("Failed to set client fields", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InternalConfigurationException("Failed to set client fields", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new InternalConfigurationException("Failed to set client fields", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new InternalConfigurationException("Failed to set client fields", (Throwable)e);
        }
    }
}

