/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.util.CachedList;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class CachedListImpl<T>
implements CachedList<T> {
    private final List<T> data = new ArrayList<T>();
    private final BellaDatiServiceImpl service;
    private final String uri;
    private final String field;
    private boolean isLoaded = false;

    public CachedListImpl(BellaDatiServiceImpl service, String uri, String field) {
        this.service = service;
        this.uri = uri;
        this.field = field;
    }

    public List<T> get() {
        return Collections.unmodifiableList(this.data);
    }

    public List<T> toList() {
        return this.get();
    }

    public CachedList<T> load() {
        this.data.clear();
        JsonNode json = this.service.loadJson(this.uri);
        if (json.get(this.field) instanceof ArrayNode) {
            ArrayNode nodes = (ArrayNode)json.get(this.field);
            for (JsonNode node : nodes) {
                try {
                    this.data.add(this.parse(this.service, node));
                }
                catch (ParseException parseException) {}
            }
        }
        this.isLoaded = true;
        return this;
    }

    public CachedList<T> loadFirstTime() {
        if (!this.isLoaded()) {
            this.load();
        }
        return this;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public String toString() {
        return this.data.toString();
    }

    protected abstract T parse(BellaDatiServiceImpl var1, JsonNode var2) throws ParseException;

    protected static class ParseException
    extends Exception {
        private static final long serialVersionUID = -3237010782121691680L;

        public ParseException(JsonNode node) {
            super("Failed to parse node " + node);
        }

        public ParseException(JsonNode node, Throwable cause) {
            super("Failed to parse node " + node, cause);
        }
    }
}

