/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dashboard.Dashboard;
import com.belladati.sdk.dashboard.Dashlet;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.DashletImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

class DashboardImpl
implements Dashboard {
    private final BellaDatiServiceImpl service;
    private final String id;
    private final String name;
    private final Date lastChange;
    private final List<Dashlet> dashlets;

    DashboardImpl(BellaDatiServiceImpl service, JsonNode json) {
        this.service = service;
        this.id = json.get("id").asText();
        this.name = json.get("name").asText();
        if (json.hasNonNull("lastChange")) {
            Date lastChange;
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            try {
                lastChange = format.parse(json.get("lastChange").asText());
            }
            catch (ParseException e) {
                lastChange = null;
            }
            this.lastChange = lastChange;
        } else {
            this.lastChange = null;
        }
        ArrayList<DashletImpl> dashlets = new ArrayList<DashletImpl>();
        if (json.hasNonNull("dashlets") && json.get("dashlets") instanceof ArrayNode) {
            for (JsonNode view : (ArrayNode)json.get("dashlets")) {
                try {
                    DashletImpl viewInfo = new DashletImpl(this.service, view);
                    dashlets.add(viewInfo);
                }
                catch (DashletImpl.DashletException dashletException) {}
            }
        }
        this.dashlets = Collections.unmodifiableList(dashlets);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getLastChange() {
        return this.lastChange != null ? (Date)this.lastChange.clone() : null;
    }

    public List<Dashlet> getDashlets() {
        return this.dashlets;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DashboardImpl) {
            return this.id.equals(((DashboardImpl)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

