/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dashboard.Dashboard;
import com.belladati.sdk.dashboard.DashboardInfo;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class DashboardInfoImpl
implements DashboardInfo {
    private final BellaDatiServiceImpl service;
    private final String id;
    private final String name;
    private final Date lastChange;

    DashboardInfoImpl(BellaDatiServiceImpl service, JsonNode json) {
        this.service = service;
        this.id = json.get("id").asText();
        this.name = json.get("name").asText();
        if (json.hasNonNull("lastChange")) {
            Date lastChange;
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            try {
                lastChange = format.parse(json.get("lastChange").asText());
            }
            catch (ParseException e) {
                lastChange = null;
            }
            this.lastChange = lastChange;
        } else {
            this.lastChange = null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getLastChange() {
        return this.lastChange != null ? (Date)this.lastChange.clone() : null;
    }

    public Dashboard loadDetails() {
        return this.service.loadDashboard(this.id);
    }

    public Object loadThumbnail() throws IOException {
        return this.service.loadDashboardThumbnail(this.id);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DashboardInfoImpl) {
            return this.id.equals(((DashboardInfoImpl)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

