/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dashboard.Dashlet;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.ViewImpl;
import com.belladati.sdk.view.View;
import com.fasterxml.jackson.databind.JsonNode;

class DashletImpl
implements Dashlet {
    private final String name;
    private final Dashlet.Type type;
    private final Object content;

    DashletImpl(BellaDatiServiceImpl service, JsonNode node) throws UnknownDashletTypeException, UnsupportedDashletContentException {
        block5: {
            block4: {
                if (!node.hasNonNull("type")) break block4;
                this.type = this.findType(node.get("type").asText());
                switch (this.type) {
                    case VIEW: {
                        this.content = this.getContentView(service, node);
                        this.name = ((View)this.content).getName();
                        break block5;
                    }
                    case TEXT: {
                        this.content = this.getContentText(node);
                        this.name = node.hasNonNull("name") ? node.get("name").asText() : "";
                        break block5;
                    }
                    default: {
                        throw new UnknownDashletTypeException("Type not implemented: " + this.type);
                    }
                }
            }
            throw new UnknownDashletTypeException("missing type");
        }
    }

    private Dashlet.Type findType(String typeString) throws UnknownDashletTypeException {
        if ("viewReport".equalsIgnoreCase(typeString)) {
            return Dashlet.Type.VIEW;
        }
        if ("textContent".equalsIgnoreCase(typeString)) {
            return Dashlet.Type.TEXT;
        }
        throw new UnknownDashletTypeException(typeString);
    }

    private View getContentView(BellaDatiServiceImpl service, JsonNode node) throws UnsupportedDashletContentException {
        if (!node.hasNonNull("canAccessViewReport") || !node.get("canAccessViewReport").asBoolean()) {
            throw new UnsupportedDashletContentException("View not accessible");
        }
        if (!node.hasNonNull("viewReport")) {
            throw new UnsupportedDashletContentException("Missing view element");
        }
        try {
            return ViewImpl.buildView(service, node.get("viewReport"));
        }
        catch (ViewImpl.UnknownViewTypeException e) {
            throw new UnsupportedDashletContentException((Throwable)e);
        }
    }

    private String getContentText(JsonNode node) throws UnsupportedDashletContentException {
        if (node.hasNonNull("textContent")) {
            return node.get("textContent").asText();
        }
        throw new UnsupportedDashletContentException("Text content missing");
    }

    public String getName() {
        return this.name;
    }

    public Dashlet.Type getType() {
        return this.type;
    }

    public Object getContent() {
        return this.content;
    }

    public String toString() {
        return "Dashlet containing " + this.type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DashletImpl) {
            return this.content.equals(((DashletImpl)obj).content);
        }
        return false;
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    class UnknownDashletTypeException
    extends DashletException {
        private static final long serialVersionUID = -9179478821813868612L;

        public UnknownDashletTypeException(String type) {
            super("Unknown view type: " + type);
        }
    }

    class UnsupportedDashletContentException
    extends DashletException {
        private static final long serialVersionUID = -7530835838695643795L;

        public UnsupportedDashletContentException(String message) {
            super(message);
        }

        public UnsupportedDashletContentException(Throwable cause) {
            super(cause);
        }
    }

    class DashletException
    extends Exception {
        private static final long serialVersionUID = -2686607915455923775L;

        public DashletException(String message) {
            super(message);
        }

        public DashletException(Throwable cause) {
            super(cause);
        }
    }
}

