/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dataset.DataSet;
import com.belladati.sdk.dataset.DataSetInfo;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.LocalizationImpl;
import com.fasterxml.jackson.databind.JsonNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

class DataSetInfoImpl
implements DataSetInfo {
    private final BellaDatiServiceImpl service;
    private final String id;
    private final String name;
    private final String description;
    private final String ownerName;
    private final Date lastChange;
    private final LocalizationImpl localization;

    DataSetInfoImpl(BellaDatiServiceImpl service, JsonNode json) {
        this.service = service;
        this.id = json.get("id").asText();
        this.name = json.get("name").asText();
        this.description = json.hasNonNull("description") ? json.get("description").asText() : "";
        this.ownerName = json.get("owner").asText();
        if (json.hasNonNull("lastChange")) {
            Date lastChange;
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            try {
                lastChange = format.parse(json.get("lastChange").asText());
            }
            catch (ParseException e) {
                lastChange = null;
            }
            this.lastChange = lastChange;
        } else {
            this.lastChange = null;
        }
        this.localization = new LocalizationImpl(json);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getName(Locale locale) {
        return this.localization.getName(locale);
    }

    public boolean hasLocalization(Locale locale) {
        return this.localization.hasLocalization(locale);
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Date getLastChange() {
        return this.lastChange != null ? (Date)this.lastChange.clone() : null;
    }

    public DataSet loadDetails() {
        return this.service.loadDataSet(this.id);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataSetInfoImpl) {
            return this.id.equals(((DataSetInfoImpl)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

