/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dataset.source.DataSource;
import com.belladati.sdk.dataset.source.DataSourceImport;
import com.belladati.sdk.dataset.source.DataSourcePendingImport;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.DataSourcePendingImportImpl;
import com.belladati.sdk.util.CachedList;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Date;

class DataSourceImpl
implements DataSource {
    private static final String TYPE_SUFFIX = "ImportTable";
    private final BellaDatiServiceImpl service;
    private final String id;
    private final String name;
    private final String type;

    DataSourceImpl(BellaDatiServiceImpl service, JsonNode json) {
        this.service = service;
        this.id = json.get("id").asText();
        this.name = json.get("name").asText();
        String type = json.get("type").asText();
        if (type != null && type.endsWith(TYPE_SUFFIX)) {
            type = type.substring(0, type.length() - TYPE_SUFFIX.length());
        }
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public CachedList<DataSourceImport> getImports() {
        return this.service.getDataSourceImports(this.id);
    }

    public DataSourcePendingImport setupImport(Date date) {
        return new DataSourcePendingImportImpl(this.service, this.id, date);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataSourceImpl) {
            return this.id.equals(((DataSourceImpl)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

