/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dataset.source.DataSourceImportBase;
import com.belladati.sdk.dataset.source.ImportInterval;
import com.belladati.sdk.dataset.source.ImportIntervalUnit;
import java.util.Date;

abstract class DataSourceImportBaseImpl
implements DataSourceImportBase {
    protected final String id;
    protected ImportInterval interval;
    protected final Date nextImport;

    protected DataSourceImportBaseImpl(String id, Date nextImport) {
        this.id = id;
        this.nextImport = nextImport;
    }

    public String getId() {
        return this.id;
    }

    public ImportInterval getRepeatInterval() {
        return this.interval;
    }

    public void setRepeatInterval(ImportInterval interval) {
        this.interval = interval;
    }

    public Date getNextExecutionDate() {
        return this.nextImport;
    }

    static enum ImportPeriod {
        CUSTOM(ImportIntervalUnit.MINUTE, 100),
        HOUR(ImportIntervalUnit.HOUR, 60),
        HOUR2(ImportIntervalUnit.HOUR, ImportPeriod.HOUR.minutes * 2),
        HOUR4(ImportIntervalUnit.HOUR, ImportPeriod.HOUR.minutes * 4),
        HOUR8(ImportIntervalUnit.HOUR, ImportPeriod.HOUR.minutes * 8),
        DAY(ImportIntervalUnit.DAY, 1440),
        DAY2(ImportIntervalUnit.DAY, ImportPeriod.DAY.minutes * 2),
        WEEK(ImportIntervalUnit.WEEK, ImportPeriod.DAY.minutes * 7),
        WEEK2(ImportIntervalUnit.WEEK, ImportPeriod.WEEK.minutes * 2),
        MONTH(ImportIntervalUnit.MONTH, ImportPeriod.DAY.minutes * 31),
        QUARTER(ImportIntervalUnit.QUARTER, ImportPeriod.MONTH.minutes * 3),
        YEAR(ImportIntervalUnit.YEAR, ImportPeriod.DAY.minutes * 365);

        final ImportIntervalUnit unit;
        final int minutes;

        private ImportPeriod(ImportIntervalUnit unit, int minutes) {
            this.unit = unit;
            this.minutes = minutes;
        }
    }

    protected static class ImportIntervalImpl
    implements ImportInterval {
        private final ImportIntervalUnit unit;
        private final int factor;

        protected ImportIntervalImpl(ImportIntervalUnit unit, int factor) {
            this.unit = unit;
            this.factor = factor;
        }

        public int getMinutes() {
            return this.unit.getMinutes() * this.factor;
        }

        public ImportIntervalUnit getUnit() {
            return this.unit;
        }

        public int getFactor() {
            return this.factor;
        }
    }
}

