/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dataset.source.DataSourceImport;
import com.belladati.sdk.dataset.source.ImportIntervalUnit;
import com.belladati.sdk.impl.DataSourceImportBaseImpl;
import com.fasterxml.jackson.databind.JsonNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class DataSourceImportImpl
extends DataSourceImportBaseImpl
implements DataSourceImport {
    private final String callerName;
    private final boolean overwriting;

    DataSourceImportImpl(JsonNode json) throws InvalidDataSourceImportException {
        super(json.get("id").asText(), DataSourceImportImpl.parseNextImport(json));
        this.callerName = json.get("createdBy").asText();
        this.overwriting = json.hasNonNull("overwritingPolicy") && !json.get("overwritingPolicy").asText().isEmpty();
        this.interval = json.hasNonNull("repeateInterval") ? DataSourceImportImpl.parseInterval(json) : null;
    }

    private static Date parseNextImport(JsonNode json) throws InvalidDataSourceImportException {
        if (!json.hasNonNull("when")) {
            throw new InvalidDataSourceImportException(json);
        }
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        try {
            return format.parse(json.get("when").asText());
        }
        catch (ParseException e) {
            throw new InvalidDataSourceImportException(json);
        }
    }

    private static DataSourceImportBaseImpl.ImportIntervalImpl parseInterval(JsonNode json) throws InvalidDataSourceImportException {
        try {
            DataSourceImportBaseImpl.ImportPeriod period = DataSourceImportBaseImpl.ImportPeriod.valueOf(json.get("repeateInterval").asText());
            if (period == DataSourceImportBaseImpl.ImportPeriod.CUSTOM) {
                return new DataSourceImportBaseImpl.ImportIntervalImpl(ImportIntervalUnit.MINUTE, DataSourceImportImpl.parseCustomMinutes(json));
            }
            return new DataSourceImportBaseImpl.ImportIntervalImpl(period.unit, period.minutes / period.unit.getMinutes());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataSourceImportException(json);
        }
    }

    private static int parseCustomMinutes(JsonNode json) throws InvalidDataSourceImportException {
        if (json.hasNonNull("repeateIntervalCustom")) {
            try {
                int minutes = Integer.parseInt(json.get("repeateIntervalCustom").asText());
                if (minutes > 0) {
                    return minutes;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new InvalidDataSourceImportException(json);
    }

    public String getCallerName() {
        return this.callerName;
    }

    public boolean isOverwriting() {
        return this.overwriting;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataSourceImportImpl) {
            return this.id.equals(((DataSourceImportBaseImpl)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    static class InvalidDataSourceImportException
    extends Exception {
        private static final long serialVersionUID = -4920843734203654180L;

        public InvalidDataSourceImportException(JsonNode node) {
            super("Invalid data source import JSON: " + node.toString());
        }
    }
}

