/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.util.Localizable;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

class LocalizationImpl
implements Localizable {
    private final String name;
    private final Map<String, String> l10n;

    LocalizationImpl(JsonNode json) {
        this.name = json.get("name").asText();
        HashMap<String, String> l10n = new HashMap<String, String>();
        if (json.hasNonNull("localization")) {
            JsonNode locNode = json.get("localization");
            Iterator iterator = locNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!((JsonNode)entry.getValue()).isTextual()) continue;
                l10n.put(((String)entry.getKey()).toLowerCase(Locale.ENGLISH), ((JsonNode)entry.getValue()).asText());
            }
        }
        this.l10n = Collections.unmodifiableMap(l10n);
    }

    public String getName(Locale locale) {
        String loc = this.l10n.get(locale.getLanguage().toLowerCase(Locale.ENGLISH));
        return loc != null ? loc : this.name;
    }

    public boolean hasLocalization(Locale locale) {
        return this.l10n.containsKey(locale.getLanguage().toLowerCase(Locale.ENGLISH));
    }
}

