/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.BellaDatiService;
import com.belladati.sdk.auth.OAuthRequest;
import com.belladati.sdk.impl.BellaDatiClient;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.TokenHolder;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.client.utils.URIBuilder;

class OAuthRequestImpl
implements OAuthRequest {
    private static final long serialVersionUID = -8823818244254801967L;
    private final BellaDatiClient client;
    private final TokenHolder tokenHolder;

    OAuthRequestImpl(BellaDatiClient client, TokenHolder tokenHolder) {
        this.client = client;
        this.tokenHolder = tokenHolder;
    }

    public URL getAuthorizationUrl() {
        try {
            return new URIBuilder(this.client.getBaseUrl() + "authorizeRequestToken/" + this.tokenHolder.getToken() + "/" + this.tokenHolder.getConsumerKey()).build().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
    }

    public BellaDatiService requestAccess() {
        this.client.postToken("oauth/accessToken", this.tokenHolder);
        return new BellaDatiServiceImpl(this.client, this.tokenHolder);
    }

    public String toString() {
        return "OAuth Authentication(server: " + this.client.getBaseUrl() + ", key: " + this.tokenHolder.getConsumerKey() + ")";
    }
}

